% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faq.R
\name{faq-adverbs-export}
\alias{faq-adverbs-export}
\title{Best practices for exporting adverb-wrapped functions}
\description{
Exporting functions created with purrr adverbs in your package
requires some precautions because the functions will contain internal
purrr code. This means that creating them once and for all when
the package is built may cause problems when purrr is updated, because
a function that the adverb uses might no longer exist.

Instead, either create the modified function once per session on package
load or wrap the call within another function every time you use it:
\itemize{
\item Using the \code{\link[=.onLoad]{.onLoad()}} hook:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' My function
#' @export
insist_my_function <- function(...) "dummy"

my_function <- function(...) \{
  # Implementation
\}

.onLoad <- function(lib, pkg) \{
  insist_my_function <<- purrr::insistently(my_function)
\}
}\if{html}{\out{</div>}}
\item Using a wrapper function:

\if{html}{\out{<div class="sourceCode">}}\preformatted{my_function <- function(...) \{
  # Implementation
\}

#' My function
#' @export
insist_my_function <- function(...) \{
  purrr::insistently(my_function)(...)
\}
}\if{html}{\out{</div>}}
}
}
\keyword{internal}
