% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_mcmc.R
\name{apply_mcmc}
\alias{apply_mcmc}
\alias{extract_samples}
\alias{summary.apply_mcmc}
\title{Fit Dynamic Borrowing MCMC Model}
\usage{
apply_mcmc(dt, formula_cov, ...)

extract_samples(object)

\method{summary}{apply_mcmc}(object, ...)
}
\arguments{
\item{dt}{A data.frame containing data required for modelling. See details}

\item{formula_cov}{A one sided formula specifying which non-treatment covariates should
be included into the model. See details}

\item{...}{Additional arguments passed onto \code{\link[=run_mcmc]{run_mcmc()}}. Only exception being the
\code{path} argument which is not supported by this function}

\item{object}{A \code{apply_mcmc} object created by \code{\link[=apply_mcmc]{apply_mcmc()}}}
}
\description{
Fit a dynamic borrowing Weibull survival model to the given dataset and extract the posterior
samples using MCMC.
See the user guide for more information on the model formulation.
See \code{\link[=run_mcmc]{run_mcmc()}} for more information on the available parameters for tuning the MCMC sampling
process
}
\details{
\subsection{\code{apply_mcmc()}}{

The \code{dt} data.frame must contain 1 row per subject with the following variables:
\itemize{
\item \strong{time} - A continuous non-zero number specifying the time that the subject had an event at
\item \strong{cnsr} - A column of 0/1's where 1 indicates that the event was censored/right truncated
\item \strong{ext} - A column of 0/1's where 1 indicates that the subject was part of the external
control
\item \strong{trt} - A column of 0/1's where 1 indicates that the subject was receiving the experimental
treatment
}

The \code{dt} data.frame may also contain any additional covariates to be used in the Weibull model
as specified by \code{formula_cov}. In order to fit a valid model \code{formula_cov} must contain
the intercept term. The formula will be automatically adjusted to include the treatment term
and as such should not be included here, if you want to include a treatment interaction term
this should be done by using \code{~ trt:covariate} and NOT via \code{~ trt*covariate}.
}

\subsection{\code{extract_samples()}}{

This function can be used to extract the samples generated by \code{apply_mcmc()}
}

\subsection{\code{summary()}}{

This function provides summary statistics about the samples generated by \code{apply_mcmc()}
}

\subsection{Extracted Samples}{

The extracted samples can be roughly defined as follows (see the user guide for full details):
\itemize{
\item \strong{\code{HR_cc_hc}} - The hazard ratio between the concurrent control arm and the historical
control arm. This can be
be thought of as the ratio of the scale parameter between the baseline trial distribution and
the baseline
external control distribution. This is equivalent to \code{exp(alpha[2] - alpha[1])}
\item \strong{\code{HR_trt_cc}} - The hazard ratio between the treatment arm and the concurrent control arm.
This is equivalent
to \code{exp(beta_trt)}
\item \strong{\code{alpha[1]}} - The shape parameter for the trial's baseline distribution
\item \strong{\code{alpha[2]}} - The shape parameter for the historical control's baseline distribution
\item \strong{\code{beta_trt}} - The log-hazard ratio for the treatment effect. This is equivalent to
\code{log(HR_trt_cc)}
\item \strong{\verb{beta_<var>}} - The log-hazard ratio for any other covariate provided to the model via
\code{formula_cov}
\item \strong{\code{r0}} - The scale parameter for the baseline distribution of both the trial and the
historical control
\item \strong{\code{tau/sigma}} - The precision/variance for \code{alpha[1]} i.e. controls how much
information is borrowed from the
historical control arm
}
}
}
