% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_spec.R
\name{.get_spec}
\alias{.get_spec}
\title{(Internal) Locate a \code{StudySpecification} in the call stack}
\usage{
.get_spec(NULL_on_error = FALSE)
}
\arguments{
\item{NULL_on_error}{if \code{TRUE}, returns \code{NULL} if a
\code{StudySpecification} object is not found rather than throwing an
error.}
}
\value{
A \code{StudySpecification}, or \code{NULL} if \code{NULL_on_error}
is \code{TRUE} and the \code{StudySpecification} can't be found.
}
\description{
\code{assigned()}/\code{ate()}/\code{ett()}/\code{cov_adj()} all need the
\code{StudySpecification} to operate. If any are called in the model without
a \code{specification=} argument, this function sees if it can find the
\code{StudySpecification} in another of these functions.
}
\details{
Note that it will never look inside \code{assigned()} (gets complicated in
formulas), only in weights or \code{cov_adj()}. E.g.

\code{lm(y ~ assigned(), weights = ate(spec), offest = cov_adj(mod1))}

\code{lm(y ~ assigned(), weights = ate(), offest = cov_adj(mod1, specification = spec))}

will both work, but

\code{lm(y ~ assigned(spec), weights = ate(), offest = cov_adj(mod1))}

will fail.
}
\keyword{internal}
