% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progressr-package.R
\docType{package}
\name{progressr}
\alias{progressr}
\alias{progressr-package}
\title{progressr: A Unifying API for Progress Updates}
\description{
The \pkg{progressr} package provides a minimal, unifying API for scripts
and packages to report progress updates from anywhere including when
using parallel processing.
}
\details{
The package is designed such that \emph{the developer} can to focus on \emph{what}
progress should be reported on without having to worry about \emph{how} to
present it.

The \emph{end user} has full control of \emph{how}, \emph{where}, and \emph{when} to render
these progress updates.  For instance, they can chose to report progress
in the terminal using \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}} (default) or
\code{\link[cli:cli_progress_bar]{cli::cli_progress_bar()}}, via the R graphical user interface (GUI)
using \code{utils::winProgressBar()} or \code{\link[tcltk:tkProgressBar]{tcltk::tkProgressBar()}}, or
via the RStudio GUI using \code{rstudioapi::jobSetProgress()}.
An alternative to above visual rendering, is to report progress as audio
using \code{\link[beepr:beep]{beepr::beep()}}.
It is also possible to use a combination of above progression handlers,
e.g. a progress bar in the terminal together with audio updates.
Besides the existing handlers, it is possible to develop custom
progression handlers.

The \pkg{progressr} package is compatible with \pkg{shiny} applications
and \pkg{knitr} rendering.

The \pkg{progressr} package uses R's condition framework for signaling
progress updated. Because of this, progress can be reported from almost
anywhere in R, e.g. from classical for and while loops, from map-reduce
APIs like the \code{\link[=lapply]{lapply()}} family of functions, \pkg{purrr}, \pkg{plyr}, and
\pkg{foreach}.
The \pkg{progressr} package will also work with parallel processing via
the \pkg{future} framework, e.g. \code{\link[future.apply:future_lapply]{future.apply::future_lapply()}},
\code{\link[furrr:future_map]{furrr::future_map()}}, and \code{\link[foreach:foreach]{foreach::foreach()}} with \pkg{doFuture}.
}
\section{Progression Handlers}{


In the terminal:
\itemize{
\item \link{handler_txtprogressbar} (built-in; default)
\item \link{handler_pbcol} (built-in)
\item \link{handler_ascii_alert} (built-in)
\item \link{handler_pbmcapply} (requires the \pkg{pbmcapply} package)
\item \link{handler_progress} (requires the \pkg{progress} package)
}

In a graphical user interface (GUI):
\itemize{
\item \link{handler_rstudio} (only in the RStudio Console)
\item \link{handler_tkprogressbar} (built-in)
\item \link{handler_winprogressbar} (built-in)
}

As sound:
\itemize{
\item \link{handler_ascii_alert} (built-in)
\item \link{handler_beepr} (requires the \pkg{beepr} package)
}

Via the file system:
\itemize{
\item \link{handler_filesize} (built-in)
}

In Shiny:
\itemize{
\item \link{withProgressShiny} (requires the \pkg{shiny} package)
}

Via notification systems:
\itemize{
\item \link{handler_ntfy} (requires the \pkg{ntfy} package)
\item \link{handler_notifier} (requires the non-CRAN \pkg{notifier} package)
\item \link{handler_rpushbullet} (requires the \pkg{RPushBullet} package)
}

Miscellaneous:
\itemize{
\item \link{handler_debug} (built-in)
\item \link{handler_newline} (built-in)
\item \link{handler_slowdown} (built-in)
\item \link{handler_void} (built-in)
}
}

\examples{
library(progressr)

xs <- 1:5

with_progress({
  p <- progressor(along = xs)
  y <- lapply(xs, function(x) {
    Sys.sleep(0.1)
    p(sprintf("x=\%g", x))
    sqrt(x)
  })
})
}
\seealso{
Useful links:
\itemize{
  \item \url{https://progressr.futureverse.org}
  \item \url{https://github.com/futureverse/progressr}
  \item Report bugs at \url{https://github.com/futureverse/progressr/issues}
}

}
\author{
\strong{Maintainer}: Henrik Bengtsson \email{henrikb@braju.com} (\href{https://orcid.org/0000-0002-7579-5165}{ORCID}) [copyright holder]

}
\keyword{iteration}
\keyword{programming}
