% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_ascii_alert.R
\name{handler_ascii_alert}
\alias{handler_ascii_alert}
\title{Progression Handler: Progress Reported as ASCII BEL Symbols (Audio or Blink) in the Terminal}
\usage{
handler_ascii_alert(
  symbol = "\\a",
  file = stderr(),
  intrusiveness = getOption("progressr.intrusiveness.audio", 5),
  target = c("terminal", "audio"),
  ...
)
}
\arguments{
\item{symbol}{(character string) The character symbol to be outputted,
which by default is the ASCII BEL character (\code{'\\a'} = \code{'\\007'}) character.}

\item{file}{(connection) A \link[base:connections]{base::connection} to where output should be sent.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler based on \code{cat("\\a", file=stderr())}.
}
\examples{
handlers("ascii_alert")
with_progress({ y <- slow_sum(1:10) })
print(y)
}
