% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRIDITscore.R
\name{PRIDITscore}
\alias{PRIDITscore}
\title{Calculate the PRIDIT scores for a ridit matrix}
\usage{
PRIDITscore(riditscores, id_vector, weightvec)
}
\arguments{
\item{riditscores}{A data frame where the first column represents IDs.
The IDs uniquely identify each row in the matrix.
The remaining columns contain the ridit scores for each ID.}

\item{id_vector}{A vector of IDs corresponding to the observations.}

\item{weightvec}{A numeric vector of PRIDIT weights (from PRIDITweight function).}
}
\value{
A data frame with two columns: "Claim.ID" containing the IDs and
  "PRIDITscore" containing the calculated PRIDIT scores (ranging from -1 to 1).
}
\description{
This function takes ridit scores and PRIDIT weights to calculate final
PRIDIT scores for each observation.
}
\examples{
# Complete workflow example
test_data <- data.frame(
  ID = c("A", "B", "C", "D", "E"),
  var1 = c(0.9, 0.85, 0.89, 1.0, 0.89),
  var2 = c(0.99, 0.92, 0.90, 1.0, 0.93),
  var3 = c(1.0, 0.99, 0.98, 1.0, 0.99)
)

# Step 1: Calculate ridit scores
ridit_result <- ridit(test_data)

# Step 2: Calculate PRIDIT weights
weights <- PRIDITweight(ridit_result)

# Step 3: Calculate final PRIDIT scores
final_scores <- PRIDITscore(ridit_result, test_data$ID, weights)
print(final_scores)

}
\references{
Brockett, P. L., Derrig, R. A., Golden, L. L., Levine, A., & Alpert, M. (2002).
Fraud classification using principal component analysis of RIDITs.
Journal of Risk and Insurance, 69(3), 341-371.
}
