% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-robustness.R
\name{plot_assurance_with_robustness}
\alias{plot_assurance_with_robustness}
\title{Plot Assurance with Robustness Ribbon (Multi-Effect Grid Friendly)}
\usage{
plot_assurance_with_robustness(
  power_results_list,
  metric = c("precision", "direction", "threshold", "bf"),
  x_effect = NULL,
  facet_by = NULL,
  precision_target = NULL,
  p_star = 0.95,
  bf_threshold = 10,
  effect_filters = NULL,
  effect_weights = NULL,
  show_individual_scenarios = FALSE,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results_list}{Named list of results objects from \code{brms_inla_power} or sequential/two-stage variants.}

\item{metric}{Which assurance metric to compute: "precision", "direction", "threshold", or "bf".}

\item{x_effect}{Name of effect grid column for x-axis (default: first detected grid column).}

\item{facet_by}{Optional effect grid column(s) to facet by.}

\item{precision_target}{CI width target if metric="precision".}

\item{p_star}{Posterior probability threshold for "direction"/"threshold".}

\item{bf_threshold}{BF10 threshold for "bf".}

\item{effect_filters}{Optional named list for filtering rows (e.g. list(treatment=0)).}

\item{effect_weights}{Optional named numeric vector for averaging over grid values.}

\item{show_individual_scenarios}{Logical; if TRUE, overlay each scenario's curve.}

\item{title, subtitle}{Optional plot labels.}
}
\value{
A ggplot object.
}
\description{
Compares assurance results from multiple scenarios by showing the range
("ribbon") of values across scenarios for each sample size and effect grid variable.
}
