% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_out.R
\name{sim_out}
\alias{sim_out}
\alias{print.sim_out}
\title{Create a 'sim_out' Object}
\usage{
sim_out(data_all, ...)

\method{print}{sim_out}(x, digits = 3, digits_descriptive = 2, fit_to_all_args = list(), ...)
}
\arguments{
\item{data_all}{The output of
\code{\link[=sim_data]{sim_data()}}.}

\item{...}{Named arguments of
objects to be added to each
replication under the element
\code{extra}. For example, if set to
\code{fit = fit_all}, where \code{fit_all}
is the output of \code{\link[=fit_model]{fit_model()}},
then \code{data_all[[1]]$extra$fit}
will be set to the first output
in \code{fit_all}.}

\item{x}{The \code{sim_out} object
to be printed.}

\item{digits}{The numbers of digits
displayed after the decimal.}

\item{digits_descriptive}{The
number of digits displayed after
the decimal for the descriptive
statistics table.}

\item{fit_to_all_args}{A named list
of arguments to be passed to
\code{\link[lavaan:sem]{lavaan::sem()}} when the model is
fitted to a sample combined from}
}
\value{
The function \code{\link[=sim_out]{sim_out()}} returns a \code{sim_out} object, which
is a list of length equal to the
length of \code{data_all}. Each element
of the list is a \code{sim_data} object
with the element \code{extra} added to
it. Other named elements will be
added under this name. For example.
the output of \code{\link[=fit_model]{fit_model()}}
for this replication can be added
to \code{fit}, under \code{extra}. See
the description of the argument
\code{...} for details.

The \code{print} method of \code{sim_out}
returns \code{x} invisibly. Called for
its side effect.
}
\description{
Combine the outputs
of \code{\link[=sim_data]{sim_data()}}, \code{\link[=fit_model]{fit_model()}},
and optionally \code{\link[=gen_mc]{gen_mc()}} and/or
\code{\link[=gen_boot]{gen_boot()}} to one
single object.
}
\details{
It merges into one object the output
of \code{\link[=sim_data]{sim_data()}}, which is a list of
\code{nrep} simulated datasets,
\code{\link[=fit_model]{fit_model()}}, which is a list of the
\code{\link[lavaan:sem]{lavaan::sem()}} output for the \code{nrep}
datasets, and optionally the output
of \code{\link[=gen_mc]{gen_mc()}} or \code{\link[=gen_boot]{gen_boot()}}, which is a list of the
\code{R} sets of Monte Carlo or bootstrap estimates
based on the results of
\code{\link[=fit_model]{fit_model()}}. The list has \code{nrep}
elements, each element with the data,
the model fit
results, and optionally the Monte
Carlo estimates matched.

This object can then be used for testing
effects of interests, which are
further processed to estimate the
power of this test.

The function \code{\link[=sim_out]{sim_out()}} is used by
the all-in-one function
\code{\link[=power4test]{power4test()}}. Users usually do not
call this function directly, though
developers can use this function to
develop other functions for power
analysis, or to build their own
workflows to do the power analysis.
}
\examples{

# Specify the model

mod <-
"m ~ x
 y ~ m + x"

# Specify the population values

es <-
"
y ~ m: m
m ~ x: m
y ~ x: n
"

# Generate the simulated datasets

dats <- sim_data(nrep = 5,
                 model = mod,
                 pop_es = es,
                 n = 100,
                 iseed = 1234)

# Fit the population model to each dataset

fits <- fit_model(dats)

# Combine the results to one object

sim_out_all <- sim_out(data_all = dats,
                       fit = fits)
sim_out_all

# Verify that the elements of fits are set to extra$fit

library(lavaan)
parameterEstimates(fits[[1]])
parameterEstimates(sim_out_all[[1]]$extra$fit)
parameterEstimates(fits[[2]])
parameterEstimates(sim_out_all[[2]]$extra$fit)

}
\seealso{
\code{\link[=power4test]{power4test()}}
}
