% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{r_mvmf_polysph}
\alias{r_mvmf_polysph}
\title{Sample mixtures of von Mises--Fisher distributed polyspherical data}
\usage{
r_mvmf_polysph(n, d, mu, kappa, prop, norm_mu = FALSE)
}
\arguments{
\item{n}{sample size.}

\item{d}{vector of size \code{r} with dimensions.}

\item{mu}{a matrix of size \code{c(m, sum(d + 1))} with the means of
each mixture components in the rows.}

\item{kappa}{a matrix of size \code{c(m, r)} with the concentrations of
each mixture components in the rows.}

\item{prop}{a vector of size \code{m} with the proportions of the mixture
components.}

\item{norm_mu}{ensure a normalization of \code{mu}? Defaults to \code{FALSE}.}
}
\value{
A matrix of size \code{c(n, sum(d) + r)} with the sample.
}
\description{
Simulates from an \eqn{m}-mixture of product of
von Mises--Fisher distributions on the polysphere \eqn{\mathcal{S}^{d_1}
\times \cdots \times \mathcal{S}^{d_r}}.
}
\examples{
# Simulate mixture of vMF data on (S^1)^2
r_mvmf_polysph(n = 10, d = c(1, 1),
               mu = rbind(c(0, 1, 0, 1), c(1, 0, 1, 0)),
               kappa = rbind(c(5, 2), c(1, 2)), prop = c(0.7, 0.3))
}
