% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sigma.R
\name{get_sigma}
\alias{get_sigma}
\title{Extract residual variability parameter estimates from a NONMEM output object.}
\usage{
get_sigma(x, output = "est", sigdig = 6, sep = "-", est.step = NULL)
}
\arguments{
\item{x}{A NONMEM output object generated using \code{\link{read_nm}}.}

\item{output}{A flag specifying the matrix or matrices to be output. Valid flag values are \code{est} (the default),
\code{se}, \code{rse}, \code{cor}, \code{cse}, \code{95ci}, or \code{all}.}

\item{sigdig}{Specifies the number of significant digits to be provided (default=6).}

\item{sep}{Specifies the separator character to use for 95\% confidence intervals (default="-").}

\item{est.step}{Specifies which estimation step to return parameters from (default is the last).}
}
\value{
A symmetrical matrix, or a list of symmetrical matrices if \code{all} is specified.
}
\description{
Extract residual variability parameter estimates from a NONMEM output object.
}
\details{
Output options are as follows:
\itemize{
\item \emph{est} returns the estimated \code{SIGMA} variance-covariance matrix.
\item \emph{se} returns the standard errors for the estimated \code{SIGMA} variance-covariance matrix.
\item \emph{rse} returns the relative standard errors for the estimated \code{SIGMA} variance-covariance matrix (\code{se/est*100}).
\item \emph{cor} returns the correlation matrix matrix.
\item \emph{cse} returns the standard errors for the correlation matrix.
\item \emph{95ci} returns the asymptotic 95\% confidence intervals for the elements of the \code{SIGMA} variance-covariance matrix (\verb{est +/- 1.96*se}).
\item \emph{all} returns all available \code{SIGMA} matrices.
}
}
\examples{
\dontrun{
 nmOutput <- read_nm("run315.xml")
 sigmas   <- get_sigma(nmOutput)
 sigmaRSEs <- get_sigma(nmOutput, "rse")
}

}
\seealso{
NONMEM (\url{https://www.iconplc.com/solutions/technologies/nonmem})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
