% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_1cmt.R
\name{calc_sd_1cmt}
\alias{calc_sd_1cmt}
\alias{calc_sd_1cmt_linear_bolus}
\alias{calc_sd_1cmt_linear_oral_1_lag}
\alias{calc_sd_1cmt_linear_infusion}
\alias{calc_sd_1cmt_linear_oral_0}
\alias{calc_sd_1cmt_linear_oral_1}
\alias{calc_sd_1cmt_linear_oral_0_lag}
\title{Calculate C(t) for a 1-compartment linear model}
\usage{
calc_sd_1cmt(t, dose, dur = NULL, tinf = NULL, ...)

calc_sd_1cmt_linear_bolus(t, dose, ...)

calc_sd_1cmt_linear_oral_1_lag(t, dose, ...)

calc_sd_1cmt_linear_infusion(t, dose, tinf, ...)

calc_sd_1cmt_linear_oral_0(t, dose, dur, ...)

calc_sd_1cmt_linear_oral_1(t, dose, ...)

calc_sd_1cmt_linear_oral_0_lag(t, dose, dur, ...)
}
\arguments{
\item{t}{Time after dose (h)}

\item{dose}{Dose}

\item{dur}{Duration of zero-order absorption (h)}

\item{tinf}{Duration of infusion (h)}

\item{...}{Passed to \code{calc_derived_1cpt()}}
}
\value{
Concentration of drug at requested time (\code{t}) after a single dose, given provided set of parameters and variables.
}
\description{
Calculate C(t) for a 1-compartment linear model
}
\section{Functions}{
\itemize{
\item \code{calc_sd_1cmt_linear_bolus()}: Calculate C(t) for a 1-compartment linear model after a single IV bolus dose

\item \code{calc_sd_1cmt_linear_oral_1_lag()}: Calculate C(t) for a 1-compartment linear model with first-order absorption after a single oral dose, with lag time

\item \code{calc_sd_1cmt_linear_infusion()}: Calculate C(t) for a 1-compartment linear model after a single IV infusion

\item \code{calc_sd_1cmt_linear_oral_0()}: Calculate C(t) for a 1-compartment linear model with zero-order absorption after a single oral dose

\item \code{calc_sd_1cmt_linear_oral_1()}: Calculate C(t) for a 1-compartment linear model with first-order absorption after a single oral dose

\item \code{calc_sd_1cmt_linear_oral_0_lag()}: Calculate C(t) for a 1-compartment linear model with zero-order absorption after a single oral dose, with lag time

}}
\examples{
Ct <- calc_sd_1cmt_linear_bolus(t=0:24, CL=6, V=25, dose=600)
Ct <- calc_sd_1cmt_linear_oral_1_lag(t=0:24, CL=6, V=25, ka=1.1, dose=600, tlag=2)
Ct <- calc_sd_1cmt_linear_infusion(t=0:24, CL=6, V=25, dose=600, tinf=1)
Ct <- calc_sd_1cmt_linear_oral_0(t=0:24, CL=6, V=25, dur=1.5, dose=600)
Ct <- calc_sd_1cmt_linear_oral_1(t=0:24, CL=6, V=25, ka=1.1, dose=600)
Ct <- calc_sd_1cmt_linear_oral_0_lag(t=0:24, CL=6, V=25, dur=1.5, dose=600, tlag=1.5)
}
\references{
Bertrand J & Mentre F (2008). Mathematical Expressions of the Pharmacokinetic and Pharmacodynamic Models
implemented in the Monolix software. \url{https://www.facm.ucl.ac.be/cooperation/Vietnam/WBI-Vietnam-October-2011/Modelling/Monolix32_PKPD_library.pdf}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}

Bill Denney, \email{wdenney@humanpredictions.com}
}
