% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_blq.R
\name{blq_trans}
\alias{blq_trans}
\alias{blq_log_trans}
\title{A transform for ggplot2 with data that may be below the lower limit of
quantification}
\usage{
blq_trans(lloq, x, multiplier = 0.5, lloq_text)

blq_log_trans(lloq, x, multiplier = 0.5, base = 10, lloq_text)
}
\arguments{
\item{lloq}{The value of the lower limit of quantification as a numeric
scalar}

\item{x}{(only used if \code{lloq} is missing), the data for \code{lloq}
estimation.}

\item{multiplier}{When data are \code{< lloq}, they are replaced by
\code{lloq*multiplier} for display.}

\item{lloq_text}{The text to use on the axis to indicate values \code{<
  lloq}.  It will be automatically set to \code{paste0("<", lloq)} if
missing.}

\item{base}{The base for the logarithm}
}
\value{
A "trans" object based on the \code{scales} package for BLQ data.
}
\description{
If the \code{lloq} is not provided, it will be estimated from the data as the
minimum value above zero.
}
\section{Functions}{
\itemize{
\item \code{blq_log_trans()}: Log-scale transformation with BLQ

}}
\examples{
\dontrun{
library(ggplot2)
ggplot(data=data.frame(x=1:10, y=1:10), aes(x=x, y=y)) +
  geom_point()

ggplot(data=data.frame(x=1:10, y=1:10), aes(x=x, y=y)) +
  geom_point() +
  scale_x_continuous(trans=blq_trans(lloq=3))

ggplot(data=data.frame(x=1:10, y=1:10), aes(x=x, y=y)) +
  geom_point() +
  scale_x_continuous(trans=blq_log10_trans(lloq=3))
}
}
\seealso{
Other BLQ Transformation: 
\code{\link{breaks_blq_general}()},
\code{\link{estimate_lloq}()},
\code{\link{ftrans_blq_linear}()},
\code{\link{itrans_blq_linear}()},
\code{\link{label_blq}()}
}
\concept{BLQ Transformation}
