% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cv.plsRglmmodel.R
\name{summary.cv.plsRglmmodel}
\alias{summary.cv.plsRglmmodel}
\title{Summary method for plsRglm models}
\usage{
\method{summary}{cv.plsRglmmodel}(object, ...)
}
\arguments{
\item{object}{an object of the class \code{"cv.plsRglmmodel"}}

\item{\dots}{further arguments to be passed to or from methods.}
}
\value{
An object of class \code{"summary.cv.plsRmodel"} if \code{model} is
missing or \code{model="pls"}. Otherwise an object of class
\code{"summary.cv.plsRglmmodel"}.
}
\description{
This function provides a summary method for the class
\code{"cv.plsRglmmodel"}
}
\examples{

data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
summary(cv.plsRglm(Y~.,data=Cornell,nt=10,NK=1,
modele="pls-glm-family",family=gaussian(), verbose=FALSE))
rm(list=c("XCornell","yCornell","bbb"))

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparing the linear and the
logistic PLS regression with qualitative predictors: application to
allelotyping data. \emph{Journal de la Societe Francaise de Statistique},
151(2), pages 1-18.
\url{https://www.numdam.org/item/JSFS_2010__151_2_1_0/}
}
\seealso{
\code{\link{summary}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{methods}
\keyword{print}
