% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapefile.R
\name{shapefile_measures}
\alias{shapefile_measures}
\title{Extract geometric measures from a shapefile object}
\usage{
shapefile_measures(shapefile, n = NULL)
}
\arguments{
\item{shapefile}{An \code{sf} object representing the shapefile. It should contain
polygonal geometries for which the measures will be calculated.}

\item{n}{An integer specifying the number of polygons to process. If \code{NULL},
all polygons are considered.}
}
\value{
A modified \code{sf} object with added columns for:
\itemize{
\item \code{xcoord}: The x-coordinate of the centroid.
\item \code{ycoord}: The y-coordinate of the centroid.
\item \code{area}: The area of the polygon (in square units).
\item \code{perimeter}: The perimeter of the polygon (in linear units).
\item \code{width}: The calculated width based on sequential distances between points.
The result will only be accurate if the polygon is rectangular.
\item \code{height}: The calculated height based on sequential distances between points.
The result will only be accurate if the polygon is rectangular.
}
}
\description{
\code{shapefile_measures()} calculates key geometric measures such as the number
of points, area, perimeter, width, height, and centroid coordinates for a
given shapefile (polygon) object.
}
\details{
This function processes a single or multi-polygon \code{sf} object and computes
geometric properties. It calculates distances between points, extracts the
centroid coordinates, and computes the area and perimeter of the polygons.
The width and height are derived from sequential distances between points.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)

path_shp <- paste0(image_pliman(), "/soy_shape.rds")
shp <- shapefile_input(path_shp)
shapefile_measures(shp)
}


}
