% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{object_scatter}
\alias{object_scatter}
\title{Plot object thumbnails at (x, y) coordinates derived from image features}
\usage{
object_scatter(
  img,
  x,
  y,
  scale = 0.1,
  xy_ratio = 1,
  xlab = x,
  ylab = y,
  erosion = 2,
  dilatation = FALSE,
  show_id = FALSE,
  color_id = "black",
  size_id = 3,
  cache = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{img}{An image of class \code{EBImage::Image} (or compatible) from which
objects will be segmented and measured.}

\item{x}{Character scalar. Name of the feature column (returned by
\code{get_measures(res)}) to use on the x-axis.}

\item{y}{Character scalar. Name of the feature column to use on the y-axis.}

\item{scale}{Numeric in (0, 1]. Relative thumbnail size as a fraction of the
data range along each axis (larger values draw larger thumbnails).}

\item{xy_ratio}{Numeric scalar. Factor applied to the vertical scaling
(y-axis) of thumbnails. Use values other than 1 to stretch or compress
thumbnails vertically.}

\item{xlab, ylab}{Character scalars used as x- and y-axis labels. Defaults to
\code{x} and \code{y}, respectively.}

\item{erosion, dilatation}{Integer (non-negative). Size of the structuring
element for morphological erosion/dilatation of the segmented objects.}

\item{show_id}{Logical. If \code{TRUE}, overlays object IDs at their
\verb{x, y} locations.}

\item{color_id}{Character. Color used for the ID labels when
\code{show_id = TRUE}.}

\item{size_id}{Numeric. Text size for the ID labels when
\code{show_id = TRUE}.}

\item{cache}{Logical. If \code{TRUE} (default), caches results of object
extraction using a simple key based on image dimensions and parameters.}

\item{verbose}{If \code{TRUE} (default), shows the progress of analysis.}

\item{...}{Additional arguments forwarded to \code{\link[=analyze_objects]{analyze_objects()}}.}
}
\value{
A list with two elements:
\itemize{
\item \code{features} — a data frame (or tibble) with object-level features
returned by \code{get_measures(res)}. Must contain columns named \code{x} and \code{y}.
\item \code{plot} — a \code{ggplot} object. The thumbnail scatter plot.
}
}
\description{
Extracts connected objects from an image, computes their features, crops each
object, converts the crop to a raster with alpha, and draws each thumbnail
centered at its corresponding \verb{(x, y)} feature location in a ggplot.
Optionally overlays object IDs. Caching can be used to avoid recomputing
object features on repeated calls.
}
\section{Scaling behavior}{

Thumbnails are sized relative to the observed ranges in \code{x} and \code{y}.
If the two axes differ substantially in range, perceived thumbnail aspect
on the plotting device may vary. Use \code{xy_ratio} to adjust vertical scaling.
}

\examples{
if(interactive()){
img <- image_pliman("potato_leaves.jpg")
plot(img)
res <- object_scatter(
 img = img,
 index = "B",
 x = "area",
 y = "solidity",
 watershed = FALSE,
 scale = 0.5
)
res$plot

# remove cached data
clear_pliman_cache()
}

}
