% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_extract}
\alias{mosaic_extract}
\title{Extract Values from a Raster Mosaic Using a Shapefile}
\usage{
mosaic_extract(mosaic, shapefile, fun = "median", ...)
}
\arguments{
\item{mosaic}{A \code{SpatRaster} object representing the raster mosaic from which
values will be extracted.}

\item{shapefile}{A shapefile, which can be a \code{SpatVector} or an \code{sf} object,
defining the regions of interest for extraction.}

\item{fun}{A character string specifying the summary function to be used for
extraction. Default is \code{"median"}.}

\item{...}{Additional arguments to be passed to \code{\link[exactextractr:exact_extract]{exactextractr::exact_extract()}}.}
}
\value{
A data frame containing the extracted values for each region defined in the shapefile.
}
\description{
This function extracts values from a raster mosaic based on the regions
defined in a shapefile using \code{\link[exactextractr:exact_extract]{exactextractr::exact_extract()}}.
}
