% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_segment_manual}
\alias{image_segment_manual}
\title{Image segmentation by hand}
\usage{
image_segment_manual(
  img,
  shape = c("free", "circle", "rectangle"),
  type = c("select", "remove"),
  viewer = get_pliman_viewer(),
  resize = TRUE,
  edge = 5,
  plot = TRUE
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{shape}{The type of shape to use. Defaults to "free". Other possible
values are "circle" and "rectangle". Partial matching is allowed.}

\item{type}{The type of segmentation. By default (\code{type = "select"}) objects
are selected. Use \code{type = "remove"} to remove the selected area from the
image.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{resize}{By default, the segmented object is resized to fill the
original image size. Use \code{resize = FALSE} to keep the segmented object in
the original scale.}

\item{edge}{Number of pixels to add in the edge of the segmented object when
\code{resize = TRUE}. Defaults to 5.}

\item{plot}{Plot the segmented object? Defaults to \code{TRUE}.}
}
\value{
A list with the segmented image and the mask used for segmentation.
}
\description{
This R code is a function that allows the user to manually segment an image based on the parameters provided. This only works in an interactive section.
}
\details{
If the shape is "free", it allows the user to draw a perimeter to
select/remove objects. If the shape is "circle", it allows the user to
click on the center and edge of the circle to define the desired area. If
the shape is "rectangle", it allows the user to select two points to define
the area.
}
\examples{
if (interactive()) {
img <- image_pliman("la_leaves.jpg")
seg <- image_segment_manual(img)
plot(seg$mask)

}
}
