% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_segment}
\alias{image_segment}
\alias{image_segment_iter}
\title{Image segmentation}
\usage{
image_segment(
  img,
  index = NULL,
  r = 1,
  g = 2,
  b = 3,
  re = 4,
  nir = 5,
  threshold = c("Otsu", "adaptive"),
  k = 0.1,
  windowsize = NULL,
  col_background = NULL,
  na_background = FALSE,
  has_white_bg = FALSE,
  fill_hull = FALSE,
  erode = FALSE,
  dilate = FALSE,
  opening = FALSE,
  closing = FALSE,
  filter = FALSE,
  invert = FALSE,
  plot = TRUE,
  nrow = NULL,
  ncol = NULL,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE
)

image_segment_iter(
  img,
  nseg = 2,
  index = NULL,
  invert = NULL,
  threshold = NULL,
  k = 0.1,
  windowsize = NULL,
  has_white_bg = FALSE,
  plot = TRUE,
  verbose = TRUE,
  nrow = NULL,
  ncol = NULL,
  parallel = FALSE,
  workers = NULL,
  ...
)
}
\arguments{
\item{img}{An image object or a list of image objects.}

\item{index}{\itemize{
\item For \code{image_segment()}, a character value (or a vector of characters)
specifying the target mode for conversion to binary image. See the available
indexes with \code{\link[=pliman_indexes]{pliman_indexes()}}.  See \code{\link[=image_index]{image_index()}} for more details.
\item For \code{image_segment_iter()} a character or a vector of characters with the
same length of \code{nseg}. It can be either an available index (described above)
or any operation involving the RGB values (e.g., \code{"B/R+G"}).
}}

\item{r, g, b, re, nir}{The red, green, blue, red-edge, and near-infrared bands
of the image, respectively. Defaults to 1, 2, 3, 4, and 5, respectively. If
a multispectral image is provided (5 bands), check the order of bands,
which are frequently presented in the 'BGR' format.}

\item{threshold}{The theshold method to be used.
\itemize{
\item By default (\code{threshold = "Otsu"}), a threshold value based
on Otsu's method is used to reduce the grayscale image to a binary image. If
a numeric value is informed, this value will be used as a threshold.
\item If \code{threshold = "adaptive"}, adaptive thresholding (Shafait et al. 2008)
is used, and will depend on the \code{k} and \code{windowsize} arguments.
\item If any non-numeric value different than \code{"Otsu"} and \code{"adaptive"} is used,
an iterative section will allow you to choose the threshold based on a
raster plot showing pixel intensity of the index.
}}

\item{k}{a numeric in the range 0-1. when \code{k} is high, local threshold
values tend to be lower. when \code{k} is low, local threshold value tend to be
higher.}

\item{windowsize}{windowsize controls the number of local neighborhood in
adaptive thresholding. By default it is set to \code{1/3 * minxy}, where
\code{minxy} is the minimum dimension of the image (in pixels).}

\item{col_background}{The color of the segmented background. Defaults to
\code{NULL} (white background).}

\item{na_background}{Consider the background as NA? Defaults to FALSE.}

\item{has_white_bg}{Logical indicating whether a white background is present.
If \code{TRUE}, pixels that have R, G, and B values equals to 1 will be
considered as \code{NA}. This may be useful to compute an image index for
objects that have, for example, a white background. In such cases, the
background will not be considered for the threshold computation.}

\item{fill_hull}{Fill holes in the objects? Defaults to \code{FALSE}.}

\item{erode, dilate, opening, closing, filter}{\strong{Morphological operations (brush size)}
\itemize{
\item \code{dilate} puts the mask over every background pixel, and sets it to
foreground if any of the pixels covered by the mask is from the foreground.
\item \code{erode} puts the mask over every foreground pixel, and sets it to
background if any of the pixels covered by the mask is from the background.
\item \code{opening} performs an erosion followed by a dilation. This helps to
remove small objects while preserving the shape and size of larger objects.
\item \code{closing} performs a dilatation followed by an erosion. This helps to
fill small holes while preserving the shape and size of larger objects.
\item \code{filter} performs median filtering in the binary image. Provide a positive
integer > 1 to indicate the size of the median filtering. Higher values are
more efficient to remove noise in the background but can dramatically impact
the perimeter of objects, mainly for irregular perimeters such as leaves
with serrated edges.
}

Hierarchically, the operations are performed as opening > closing > filter.
The value declared in each argument will define the brush size.}

\item{invert}{Inverts the binary image, if desired. For
\code{image_segmentation_iter()} use a vector with the same length of \code{nseg}.}

\item{plot}{Show image after processing?}

\item{nrow, ncol}{The number of rows or columns in the plot grid. Defaults to
\code{NULL}, i.e., a square grid is produced.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 70\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{nseg}{The number of iterative segmentation steps to be performed.}

\item{...}{Additional arguments passed on to \code{image_segment()}.}
}
\value{
\itemize{
\item \code{image_segment()} returns list containing \code{n} objects where \code{n} is the
number of indexes used. Each objects contains:
\itemize{
\item \code{image} an image with the RGB bands (layers) for the segmented object.
\item \code{mask} A mask with logical values of 0 and 1 for the segmented image.
}
\item \code{image_segment_iter()} returns a list with (1) a data frame with the
proportion of pixels in the segmented images and (2) the segmented images.
}
}
\description{
\itemize{
\item \code{image_segment()} reduces a color, color near-infrared, or grayscale images
to a segmented image using a given color channel (red, green blue) or even
color indexes (See \code{\link[=image_index]{image_index()}} for more details). The Otsu's thresholding
method (Otsu, 1979) is used to automatically perform clustering-based image
thresholding.
\item \code{image_segment_iter()} Provides an iterative image segmentation, returning
the proportions of segmented pixels.
}
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("soybean_touch.jpg", plot = TRUE)
image_segment(img, index = c("R, G, B"))
}


}
\references{
Nobuyuki Otsu, "A threshold selection method from gray-level
histograms". IEEE Trans. Sys., Man., Cyber. 9 (1): 62-66. 1979.
\doi{10.1109/TSMC.1979.4310076}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
