% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rock_paper_scissors.R
\name{play_rock_paper_scissors}
\alias{play_rock_paper_scissors}
\title{Play a game of rock, paper, scissors in the console}
\usage{
play_rock_paper_scissors(
  selection = c(NA, "rock", "paper", "scissors"),
  predict = TRUE,
  record_data = rlang::is_interactive(),
  animate = rlang::is_interactive(),
  header = rlang::is_interactive()
)
}
\arguments{
\item{selection}{Whether to throw rock, paper, or scissors.
Can be abbreviated as "r", "p", or "s".
Defaults to \code{NA}, which interactively asks which to throw.}

\item{predict}{If \code{TRUE}, the computer player fits a model on past games to
predict what you will throw and try to beat you.}

\item{record_data}{If \code{TRUE}, save data from this game into a file.
This data is used for predictions when \code{predict} is \code{TRUE}.
Defaults to \code{TRUE} if the session is \link{interactive} and \code{FALSE} otherwise.}

\item{animate}{If \code{TRUE}, play a "rock, paper, scissors, shoot!" animation
before revealing what you and the computer throw.
Defaults to \code{TRUE} if the session is \link{interactive} and \code{FALSE} otherwise.}

\item{header}{If \code{TRUE}, prints a header for the game.
Defaults to \code{TRUE} if the session is \link{interactive} and \code{FALSE} otherwise.}
}
\description{
Play a game of rock, paper, scissors in the console
}
\examples{
play_rock_paper_scissors("rock")

if (rlang::is_interactive()) play_rock_paper_scissors()
}
