% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssl.R
\name{ssl}
\alias{ssl}
\title{Calculates the short shelf life of an opening inventories, also called obsolescence risks}
\usage{
ssl(dataset, DFU, Period, Demand, Opening)
}
\arguments{
\item{dataset}{a dataframe with the demand in weekly or monthly bucket for each item}

\item{DFU}{name of an item, a SKU, or a node like an item x location}

\item{Period}{a period of time, expressed in monthly or weekly bucket}

\item{Demand}{the quantity of an item planned to be consumed in units for a given period}

\item{Opening}{the breakdown of the opening inventories by expiry date, or percentage of minimum remaining shelflife for use}
}
\value{
a dataframe with the SSL.Qty related to the Opening Inventories of each item
}
\description{
Calculates the short shelf life of an opening inventories, also called obsolescence risks
}
\examples{
ssl(dataset = slob, DFU, Period, Demand, Opening)

}
