% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_new}
\alias{pipe_new}
\title{Create new pipeline}
\usage{
pipe_new(name, data = NULL, logger = NULL)
}
\arguments{
\item{name}{the name of the Pipeline}

\item{data}{optional data used at the start of the pipeline. The
data also can be set later using the \code{\link[=pipe_set_data]{pipe_set_data()}} function.}

\item{logger}{custom logger to be used for logging. If no logger
is provided, the default logger is used, which should be sufficient
for most use cases.
If you do want to use your own custom log function, you need to
provide a function that obeys the following form:

\verb{function(level, msg, ...) \{ your custom logging code here \}}

The \code{level} argument is a string and will be one of \code{info}, \code{warn},
or \code{error}. The \code{msg} argument is a string containing the message
to be logged. The \code{...} argument is a list of named parameters,
which can be used to add additional information to the log message.
Currently, this is only used to add the context in case of a step
giving a warning or error.

Note that with the default logger, the log layout can be altered
any time via \code{\link[=set_log_layout]{set_log_layout()}}.}
}
\value{
returns the \code{Pipeline} object invisibly
}
\description{
A new pipeline is always initialized with one 'data' step,
which basically is a function returning the data.
}
\examples{
data <- data.frame(x = 1:2, y = 3:4)
p <- pipe_new("myPipe", data = data)
p |> pipe_run() |> pipe_get_out("data")

# Setting data later
p <- pipe_new("myPipe")
pipe_get_data(p)

p <- pipe_set_data(p, data)
pipe_get_data(p)
p |> pipe_run() |> pipe_get_out("data")

# Initialize with custom logger
my_logger <- function(level, msg, ...) {
   cat(level, msg, "\n")
}
p <- pipe_new("myPipe", data = data, logger = my_logger)
p |> pipe_run() |> pipe_get_out("data")
}
