% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladderShow.R
\name{ladderShow}
\alias{ladderShow}
\title{Show ladders}
\usage{
ladderShow(
  tree,
  mainCol = "black",
  ladderEdgeCol = "red",
  ladderNodeCol = "red",
  ...
)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{mainCol}{colour for edges which are not ladders (default is black)}

\item{ladderEdgeCol}{colour for ladder edges (default is red)}

\item{ladderNodeCol}{colour for ladder nodes (default is red)}

\item{...}{further arguments to be passed to plot.phylo}
}
\value{
A plot of the tree, with ladder edges and nodes highlighted by colour.
}
\description{
Plot a tree, highlighting any ladders within it.
}
\examples{
## Highlight in blue the ladders in a random tree with 50 tips:
tree <- rtree(50)
ladderShow(tree, edge.width=2)
# compare to:
ladderSizes(tree)


}
\seealso{
\code{\link{ladderSizes}}
}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}

Michael Boyd \email{mboyd855@gmail.com}
}
