% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phraseDocFunctions.R
\name{getPhrases}
\alias{getPhrases}
\title{Display Frequency Matrix for Documents}
\usage{
getPhrases(pd, doc, ids = TRUE)
}
\arguments{
\item{pd}{A phraseDoc object}

\item{doc}{An integer vector containing indices of documents, or a character
vector containing the ids of documents (column names)}

\item{ids}{A logical value with TRUE (default) to return ids (if available), 
FALSE to return indices}
}
\value{
A matrix with the documents and # of occurrences of principal phrases
for the documents in \code{docs}
}
\description{
Display a frequency matrix containing all the documents for which the indices
are given in docs with their principal phrases and the number of times they
occur in each document.
}
\examples{
tst=c("This is a test text",
      "This is a test text 2",
      "This is another test text",
      "This is another test text 2",
      "This girl will test text that man",
      "This boy will test text that man")
pd=phraseDoc(tst)
getPhrases(pd, c(1,3))
}
