# This file is automatically generated by data-raw/create_sdtms_data.R.
# For updating it please edit inst/extdata/sdtms-specs.json and rerun create_sdtms_data.R.
# Manual edits are not recommended, as changes may be overwritten.
#' Disease Response (PCWG3) for Oncology
#'
#' A SDTM RS dataset for oncology studies using PCWG3 criteria intended for examples of ADaM dataset creation
#'
#' @name rs_onco_pcwg3
#' @title Disease Response (PCWG3) for Oncology
#' @keywords dataset
#' @description A SDTM RS dataset for oncology studies using PCWG3 criteria intended for examples of ADaM dataset creation
#' @docType data
#' @format A data frame with 14 columns:
#'   \describe{
#'     \item{STUDYID}{Study Identifier}
#'     \item{DOMAIN}{Domain Abbreviation}
#'     \item{USUBJID}{Unique Subject Identifier}
#'     \item{RSSEQ}{Sequence Number}
#'     \item{RSTESTCD}{Response Assessment Short Name}
#'     \item{RSTEST}{Response Assessment Name}
#'     \item{RSCAT}{Category for Response Assessment}
#'     \item{RSORRES}{Response Assessment Original Result}
#'     \item{RSSTRESC}{Response Assessment Result in Std Format}
#'     \item{RSEVAL}{Evaluator}
#'     \item{VISITNUM}{Visit Number}
#'     \item{VISIT}{Visit Name}
#'     \item{RSDTC}{Date/Time of Response Assessment}
#'     \item{RSDY}{Study Day of Response Assessment}
#'   }
#'
#' @source Generated dataset
#' @author Tomoyuki Namai
#' @details Contains a set of 4 unique Test Short Names and Test Names: \tabular{ll}{
#'   \strong{RSTESTCD} \tab \strong{RSTEST} \cr
#'   BONERESP \tab Bone Response        \cr
#'   OVRLRESP \tab Overall Response     \cr
#'   SFTSRESP \tab Soft Tissue Response \cr
#'   TMRESP   \tab Tumor Marker Response
#' }

"rs_onco_pcwg3"
