#I'm not thoroughly testing the output of the quantile, mantel, etc. methods, because those are maintained by other people
# - though perhaps a few worked examples? Might help to check my own code...
#Setup
require(testthat)
require(picante)
require(pez)
data(phylocom)
data <- comparative.comm(phylocom$phylo, phylocom$sample, traits=phylocom$traits, warn=FALSE)

context("eco.trait.regression")

test_that("quantile", {
  set.seed(123)
  basic.quantile <<- eco.trait.regression(data)
  set.seed(123)
  expect_equal(basic.quantile$method, eco.trait.regression(data, method="quantile")$method)
  expect_equal(basic.quantile$method, "quantile")
  expect_equal(names(basic.quantile), c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "data", "altogether"))
  expect_equal(basic.quantile$permute, 0)
  expect_equal(basic.quantile$altogether, TRUE)
  expect_equal(basic.quantile$method, "quantile")
  expect_equal(basic.quantile$randomisations, list())
  expect_equivalent(round(basic.quantile$obs.slope,4), -0.1127)
  expect_equal(basic.quantile$data, data)
  expect_equal(basic.quantile$type, "eco.trait.regression")
  expect_equal(class(basic.quantile), "eco.xxx.regression")
  
  set.seed(123)
  expect_warning(complex.quantile <<- eco.trait.regression(data, randomisation="richness", permute=10, altogether=FALSE, tau=c(0.3, 0.7)))
  expect_equal(complex.quantile$method, basic.quantile$method)
  expect_equivalent(round(coef(complex.quantile[[1]]$observed),4), matrix(c(0,0,0.3333,-0.0635), nrow=2, ncol=2))
  expect_equal(names(complex.quantile), c("", "", "", "", "type", "data", "altogether", "permute", "method"))
  expect_equal(complex.quantile$permute, 10)
  expect_equal(complex.quantile$altogether, FALSE)
  expect_equal(complex.quantile$method, "quantile")
  expect_equal(complex.quantile$data, data)
  expect_equal(names(complex.quantile[[1]]), c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "altogether"))
  expect_equivalent(round(coef(complex.quantile[[1]]$randomisations[[5]]),4), matrix(c(0,0,0.25,0), nrow=2, ncol=2))
  expect_equal(complex.quantile$type, "eco.trait.regression")
  expect_equal(class(complex.quantile), "eco.xxx.regression.list")
})

test_that("mantel", {
  set.seed(123)
  basic.mantel <<- eco.trait.regression(data, method="mantel")
  expect_equal(names(basic.mantel), names(basic.quantile))
  expect_equal(basic.mantel$permute, basic.quantile$permute)
  expect_equal(basic.mantel$altogether, basic.quantile$altogether)
  expect_equal(basic.mantel$method, "mantel")
  expect_equal(basic.mantel$randomisations, basic.quantile$randomisations)
  expect_equal(round(basic.mantel$obs.slope,4), -0.4393)
  expect_equal(basic.mantel$data, data)
  expect_equal(basic.mantel$type, "eco.trait.regression")
  expect_equal(class(basic.mantel), "eco.xxx.regression")
  
  set.seed(123)
  complex.mantel <<- eco.trait.regression(data, method="mantel", randomisation="frequency", permute=10, altogether=FALSE)
  expect_equal(names(complex.mantel), names(complex.quantile))
  expect_equal(complex.mantel$permute, complex.quantile$permute)
  expect_equal(complex.mantel$altogether, complex.quantile$altogether)
  expect_equal(complex.mantel$method, "mantel")
  expect_equal(complex.mantel$data, data)
  expect_equal(names(complex.mantel[[1]]), c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "altogether"))
  expect_equal(round(complex.mantel[[1]]$observed$statistic,4), -0.1839)
  expect_equal(round(complex.mantel[[1]]$randomisations[[5]]$statistic,4), -0.0723)
  expect_equal(complex.mantel$type, "eco.trait.regression")
  expect_equal(class(complex.mantel), "eco.xxx.regression.list")
})

test_that("lm", {
  set.seed(123)
  basic.lm <<- eco.trait.regression(data, method="lm")
  set.seed(123)
  expect_equal(names(basic.lm), names(basic.quantile))
  expect_equal(basic.lm$permute, basic.quantile$permute)
  expect_equal(basic.lm$altogether, basic.quantile$altogether)
  expect_equal(basic.lm$method, "lm")
  expect_equal(basic.lm$randomisations, basic.lm$randomisations)
  expect_equivalent(round(basic.lm$obs.slope,4), -0.1255)
  expect_equal(basic.lm$data, data)
  expect_equal(basic.lm$type, "eco.trait.regression")
  expect_equal(class(basic.lm), "eco.xxx.regression")
  
  set.seed(123)
  complex.lm <- eco.trait.regression(data, method="lm", randomisation="independentswap", permute=10, altogether=FALSE)
  expect_equivalent(round(coef(complex.lm[[1]]$observed),4), c(0.2221,-0.0449))
  expect_equal(names(complex.lm), names(complex.quantile))
  expect_equal(complex.lm$permute, complex.quantile$permute)
  expect_equal(complex.lm$altogether, complex.quantile$altogether)
  expect_equal(complex.lm$method, "lm")
  expect_equal(complex.lm$data, data)
  expect_equal(names(complex.lm[[1]]), c("observed", "randomisations", "obs.slope", "rnd.slopes", "method", "permute", "randomisation", "type", "altogether"))
  expect_equivalent(round(coef(complex.lm[[1]]$randomisations[[5]]),4), c(0.1691,0.0134))
  expect_equal(complex.lm$type, "eco.trait.regression")
  expect_equal(class(complex.lm), "eco.xxx.regression.list")
})
