% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_load.R
\name{robust_load}
\alias{robust_load}
\title{Robustly Load R Objects from a URL with Retry Logic}
\usage{
robust_load(url, max_attempts = NULL, delay = 2, envir = .GlobalEnv, ...)
}
\arguments{
\item{url}{A character string specifying the URL from which to load the
`.RData` object.}

\item{max_attempts}{The maximum number of attempts before giving up.
If `NULL` (the default), the function will retry indefinitely until
successful.}

\item{delay}{The number of seconds to wait between attempts (default = 2).}

\item{envir}{The environment into which the data should be loaded
(default is the global environment).}

\item{...}{Parameters to pass to the `load()` function}
}
\value{
Invisibly returns `TRUE` if loading succeeds. On failure after
reaching the maximum number of attempts, an error is thrown.
}
\description{
Attempts to load an R object from a URL using `load()`, with automatic
retries on failure. By default, it will retry indefinitely until successful.
}
\details{
This function wraps a call to `load(url(...))` in a retry loop. It is useful
when loading data from unstable remote sources (e.g., OSF, Dropbox, GitHub)
where temporary network errors may occur. Users may optionally set a maximum
number of retry attempts and a delay between retries. The function also
closes the connection after each attempt to prevent resource leaks.
}
\examples{
# Example of a successful load (will do nothing if URL is valid)
\donttest{
robust_load("https://osf.io/download/yx5h6/")

# Example with limited retries
robust_load("https://osf.io/download/yx5h6/", max_attempts = 4, delay = 1)

# Example of a failing load, wrapped safely to pass R CMD check
try(
  robust_load("https://osf.io/download/THISISATEST/", max_attempts = 3, delay = 1),
  silent = TRUE
)
}
}
\concept{utilities}
