% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeatability.R
\name{repeatability}
\alias{repeatability}
\title{Repeatability.}
\usage{
repeatability(measure1, measure2)
}
\arguments{
\item{measure1}{Vector of scores from the measure at time 1.}

\item{measure2}{Vector of scores from the measure at time 2.}
}
\value{
Dataframe with the coefficient of repeatability (\code{CR}), bias, the lower
limit of agreement (\code{lowerLOA}), and the upper limit of agreement
(\code{upperLOA}). Also generates a Bland-Altman plot with a solid black
reference line (indicating a difference of zero), a dashed red line
indicating the bias, and dashed blue lines indicating the limits of
agreement.
}
\description{
Estimate the repeatability of a measure's scores across two time points.
}
\details{
Estimates the coefficient of repeatability (CR), bias, and the lower and
upper limits of agreement (LOA).
}
\examples{
v1 <- rnorm(1000, mean = 100, sd = 15)
v2 <- v1 + rnorm(1000, mean = 1, sd = 3)
repeatability(v1, v2)
}
\seealso{
Other reliability: 
\code{\link{reliabilityOfDifferenceScore}()}
}
\concept{reliability}
