% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcapProgressBar.R
\name{redcapProgressBar}
\alias{redcapProgressBar}
\title{Progress Bar for REDCap.}
\usage{
redcapProgressBar(numSurveys, beginning = 2, end = 99)
}
\arguments{
\item{numSurveys}{the number of surveys to establish progress.}

\item{beginning}{the first value to use in the sequence.}

\item{end}{the last value to use in the sequence.}
}
\value{
sequence of numbers for the progress bar in REDCap.
}
\description{
Function that identifies the values for a progress bar in REDCap.
}
\details{
A progress bar in REDCap can be created using the following code:
\preformatted{
  Progress:
  <div style="width:100\%;border:0;margin:0;padding:0;background-color:
  #A9BAD1;text-align:center;"><div style="width:2\%;border: 0;margin:0;
  padding:0;background-color:#8491A2"><span style="color:#8491A2">.
  </span></div></div>
}
where \code{width:2\%} specifies the progress (out of 100\%).
}
\examples{
redcapProgressBar(numSurveys = 6)
redcapProgressBar(6)
redcapProgressBar(4)
redcapProgressBar(numSurveys = 7, beginning = 1, end = 99)
}
