% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recodeIntensity.R
\name{recode_intensity}
\alias{recode_intensity}
\alias{mark_intensity_as_zero}
\title{Recode Intensity.}
\usage{
recode_intensity(intensity, did_not_occur = NULL, frequency = NULL)

mark_intensity_as_zero(
  item_names,
  data,
  did_not_occur_vars = NULL,
  frequency_vars = NULL
)
}
\arguments{
\item{intensity}{The intensity of the behavior.}

\item{did_not_occur}{Whether or not the behavior did NOT occur. If \code{0},
the behavior did occur (in the given timeframe). If \code{1}, the behavior
did not occur in (in the given timeframe).}

\item{frequency}{The frequency of the behavior.}

\item{item_names}{The names of the questionnaire items.}

\item{data}{The data object.}

\item{did_not_occur_vars}{The name(s) of the variables corresponding to
whether the behavior did not occur in the past year (\code{did_not_occur}).}

\item{frequency_vars}{The name(s) of the variables corresponding to the
number of occurrences (\code{num_occurrences}).}
}
\value{
The intensity of the behavior.
}
\description{
Recode intensity of behavior based on frequency of behavior.
}
\details{
Recodes the intensity of behavior to zero if the frequency of the behavior is
zero (i.e., if the behavior has not occurred).
}
\concept{behaviorIntensity}
