% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimalCutoff.R
\name{optimalCutoff}
\alias{optimalCutoff}
\title{Optimal Cutoff.}
\usage{
optimalCutoff(predicted, actual, UH = NULL, UM = NULL, UCR = NULL, UFA = NULL)
}
\arguments{
\item{predicted}{vector of continuous predicted values.}

\item{actual}{vector of binary actual values (\code{1} = present and \code{0}
= absent).}

\item{UH}{(optional) utility of hits (true positives), specified as a value
from 0-1, where 1 is the most highly valued and 0 is the least valued.}

\item{UM}{(optional) utility of misses (false negatives), specified as a
value from 0-1, where 1 is the most highly valued and 0 is the least valued.}

\item{UCR}{(optional) utility of correct rejections (true negatives),
specified as a value from 0-1, where 1 is the most highly valued and 0 is the
least valued.}

\item{UFA}{(optional) utility of false positives (false positives), specified
as a value from 0-1, where 1 is the most highly valued and 0 is the least
valued.}
}
\value{
The optimal cutoff and optimal accuracy index at that cutoff based
on:
\itemize{
  \item \code{percentAccuracy} = percent accuracy
  \item \code{percentAccuracyByChance} = percent accuracy by chance
  \item \code{RIOC} = relative improvement over chance
  \item \code{relativeImprovementOverPredictingFromBaseRate} = relative
  improvement over predicting from the base rate
  \item \code{PPV} = positive predictive value
  \item \code{NPV} = negative predictive value
  \item \code{youdenJ} = Youden's J statistic
  \item \code{balancedAccuracy} = balanced accuracy
  \item \code{f1Score} = F1-score
  \item \code{mcc} = Matthews correlation coefficient
  \item \code{diagnosticOddsRatio} = diagnostic odds ratio
  \item \code{positiveLikelihoodRatio} = positive likelihood ratio
  \item \code{negativeLikelhoodRatio} = negative likelihood ratio
  \item \code{dPrimeSDT} = d-Prime index from signal detection theory
  \item \code{betaSDT} = beta index from signal detection theory
  \item \code{cSDT} = c index from signal detection theory
  \item \code{aSDT} = a index from signal detection theory
  \item \code{bSDT} = b index from signal detection theory
  \item \code{differenceBetweenPredictedAndObserved} = difference between
  predicted and observed values
  \item \code{informationGain} = information gain
  \item \code{overallUtility} = overall utility (if utilities were specified)
}
}
\description{
Find the optimal cutoff for different aspects of accuracy. Actuals should be
binary, where \code{1} = present and \code{0} = absent.
}
\details{
Identify the optimal cutoff for different aspects of accuracy of predicted
values in relation to actual values by specifying the predicted values and
actual values. Optionally, you can specify the utility of hits, misses,
correct rejections, and false alarms to calculate the overall utility of
each possible cutoff.
}
\examples{
# Prepare Data
data("USArrests")
USArrests$highMurderState <- NA
USArrests$highMurderState[which(USArrests$Murder >= 10)] <- 1
USArrests$highMurderState[which(USArrests$Murder < 10)] <- 0

# Determine Optimal Cutoff
optimalCutoff(predicted = USArrests$Assault,
  actual = USArrests$highMurderState)
optimalCutoff(predicted = USArrests$Assault,
  actual = USArrests$highMurderState,
  UH = 1, UM = 0, UCR = .9, UFA = 0)
}
\seealso{
Other accuracy: 
\code{\link{accuracyAtCutoff}()},
\code{\link{accuracyAtEachCutoff}()},
\code{\link{accuracyOverall}()},
\code{\link{nomogrammer}()},
\code{\link{posttestOdds}()}
}
\concept{accuracy}
