% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCorrelationToScatterplot.R
\name{addText}
\alias{addText}
\title{Add Correlation to Scatterplot.}
\usage{
addText(
  x,
  y,
  xcoord = NULL,
  ycoord = NULL,
  size = 1,
  col = NULL,
  method = "pearson"
)
}
\arguments{
\item{x}{vector of the variable for the x-axis.}

\item{y}{vector of the variable for the y-axis.}

\item{xcoord}{x-coordinate for the location of the text.}

\item{ycoord}{y-coordinate for the location of the text.}

\item{size}{size of the text font.}

\item{col}{color of the text font.}

\item{method}{method for calculating the association. One of:
\itemize{
  \item \code{"pearson"} = Pearson product moment correlation coefficient
  \item \code{"spearman"} = Spearman's rho
  \item \code{"kendall"} = Kendall's tau
}}
}
\value{
Correlation coefficient, degrees of freedom, and p-value printed on
scatterplot.
}
\description{
Add correlation text to scatterplot.
}
\details{
Adds a correlation coefficient and associated p-value to a scatterplot.
}
\examples{
# Prepare Data
data("USArrests")

# Scatterplot
plot(USArrests$Assault, USArrests$Murder)
addText(x = USArrests$Assault, y = USArrests$Murder)
}
\seealso{
Other plot: 
\code{\link{plot2WayInteraction}()},
\code{\link{ppPlot}()},
\code{\link{semPlotInteraction}()},
\code{\link{vwReg}()}

Other correlations: 
\code{\link{cor.table}()},
\code{\link{crossTimeCorrelation}()},
\code{\link{crossTimeCorrelationDF}()},
\code{\link{partialcor.table}()},
\code{\link{vwReg}()}
}
\concept{correlations}
\concept{plot}
