% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{get_url_parameters}
\alias{get_url_parameters}
\title{Parse application passed URL parameters}
\usage{
get_url_parameters(session)
}
\arguments{
\item{session}{shiny session object}
}
\value{
named list of url parameters and values.  List may be empty if
no URL parameters were passed when the application instance was launched
}
\description{
This function returns any url parameters passed to the application as
a named list.  Keep in mind url parameters are always user-session scoped
}
\section{Shiny Usage}{

Call this function from \code{program/server_local.R} or any other server file
}

\examples{
  library(shiny)
  library(periscope2)

  # Display application info
  observeEvent(input$app_info, {
               url_params <- get_url_parameters(session)
               show_alert(html                = TRUE,
                          showCloseButton     = FALSE,
                          animation           = "slide-from-top",
                          closeOnClickOutside = TRUE,
                          text                = url_params[["passed_paramter"]],
                          title               = "alert title")
  })


}
\seealso{
\link[periscope2:set_app_parameters]{periscope2:set_app_parameters()}

\link[periscope2:add_ui_footer]{periscope2:add_ui_footer()}

\link[periscope2:add_ui_left_sidebar]{periscope2:add_ui_left_sidebar()}

\link[periscope2:add_ui_header]{periscope2:add_ui_header()}

\link[periscope2:add_ui_body]{periscope2:add_ui_body()}

\link[periscope2:add_ui_right_sidebar]{periscope2:add_ui_right_sidebar()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}
}
