% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_discrimination.R
\name{item_discrimination}
\alias{item_discrimination}
\alias{item_totalcor}
\title{Discrimination and Item-Total Correlation of Questionnaire Items}
\usage{
item_discrimination(x, standardize = FALSE, corrected = TRUE, verbose = TRUE)

item_totalcor(x, standardize = FALSE, corrected = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{standardize}{Logical, if \code{TRUE}, the data frame's vectors will be
standardized. Recommended when the variables have different measures /
scales.}

\item{corrected}{Logical, if \code{TRUE}, the item-total correlations are corrected
for the item itself (default). If \code{FALSE}, the item-total correlations are
calculated without correction.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
A data frame with the item discrimination (\emph{corrected item-total
correlations}) for each item of the scale.
}
\description{
Compute various measures of internal consistencies for tests or
item-scales of questionnaires. \code{item_discrimination()} calculates the
corrected item-total correlations for each item of \code{x} with the remaining
items. \code{item_totalcor()} by default calculates the item-total correlations
(without correction).
}
\details{
\code{item_totalcor()} calculates the item-total correlations (without
correction). A positive item-total correlation indicates that an item
successfully aligns with the overall test, with higher values signifying a
better fit. Conversely, a value near zero suggests the item is not measuring
the intended construct, while a negative correlation is a major red flag that
the item is flawed, miskeyed, or measures the opposite of what is intended.
This means a positive correlation is desired, a zero correlation is
problematic, and a negative correlation requires immediate attention.

The standard item-total correlation has an inherent flaw: the score of the
item being analyzed is included in the total score. This inclusion can
artificially inflate the correlation coefficient, as an item will always
correlate with itself. The \emph{corrected} item-total correlation, or \emph{item
discrimination}, addresses this issue by calculating the correlation between
the score on a single item and the sum of the scores of all other items on
the scale. This is done with \code{item_discrimination()}. The absolute value of
the item discrimination indices should be above \code{0.2}. An index between \code{0.2}
and \code{0.4} is considered as "fair", while a satisfactory index ranges from
\code{0.4} to \code{0.7}. Items with low discrimination indices are often ambiguously
worded and should be examined. Items with negative indices should be examined
to determine why a negative value was obtained (e.g. reversed answer
categories regarding positive and negative poles - in such cases, use
\code{\link[datawizard:reverse]{datawizard::reverse()}} to reverse-code items in advance).

\strong{Interpretation of the Corrected Item-Total Correlation Values:}\tabular{lll}{
   Corrected Item-Total Correlation Value \tab Interpretation \tab Action \cr
   \strong{Above 0.40} \tab The item has a very good discrimination and is strongly related to the underlying construct. \tab Retain the item. \cr
   \strong{0.30 to 0.39} \tab The item has good discrimination and contributes positively to the scale's internal consistency. \tab Retain the item. \cr
   \strong{0.20 to 0.29} \tab The item has marginal discrimination. While not ideal, it may still be acceptable, especially in shorter scales or when measuring a very broad construct. \tab Consider revising the item for clarity or content. If other items have stronger correlations, this one might be a candidate for removal if the scale needs to be shortened. \cr
   \strong{Below 0.20} \tab The item has poor discrimination. It does not correlate well with the rest of the scale and may be measuring something else. Its inclusion is likely to decrease the overall reliability (e.g., Cronbach's Alpha) of the scale. \tab Revise the item substantially or, more likely, remove it from the scale. \cr
   \strong{Negative Value} \tab The item is negatively related to the rest of the scale. This is a serious issue. \tab The item must be revised or removed. Check for scoring errors (e.g., a reverse-keyed item that wasn't properly recoded). \cr
}


\code{item_discrimination()} and \code{item_totalcor()} only differ in the default
value of the \code{corrected} argument. The former calculates the corrected
item-total correlations, while the latter calculates the item-total
correlations.
}
\examples{
data(mtcars)
x <- mtcars[, c("cyl", "gear", "carb", "hp")]
item_discrimination(x)
item_totalcor(x)
}
\references{
\itemize{
\item Kelava A, Moosbrugger H (2020). Deskriptivstatistische Itemanalyse und
Testwertbestimmung. In: Moosbrugger H,  Kelava A, editors. Testtheorie und
Fragebogenkonstruktion. Berlin, Heidelberg: Springer, 143–158
}
}
