// Generated by rstantools.  Do not edit by hand.

/*
    pema is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pema is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pema.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_horseshoe_MA_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 71> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 44, column 2 to column 15)",
  " (in 'string', line 45, column 2 to column 30)",
  " (in 'string', line 46, column 2 to column 13)",
  " (in 'string', line 48, column 2 to column 26)",
  " (in 'string', line 49, column 2 to column 24)",
  " (in 'string', line 50, column 2 to column 28)",
  " (in 'string', line 51, column 2 to column 29)",
  " (in 'string', line 54, column 2 to column 14)",
  " (in 'string', line 55, column 2 to column 26)",
  " (in 'string', line 56, column 2 to column 20)",
  " (in 'string', line 86, column 2 to column 56)",
  " (in 'string', line 87, column 2 to column 31)",
  " (in 'string', line 88, column 2 to column 24)",
  " (in 'string', line 58, column 2 to column 65)",
  " (in 'string', line 59, column 2 to column 31)",
  " (in 'string', line 65, column 11 to column 12)",
  " (in 'string', line 65, column 4 to column 33)",
  " (in 'string', line 68, column 6 to column 40)",
  " (in 'string', line 66, column 19 to line 69, column 5)",
  " (in 'string', line 66, column 4 to line 69, column 5)",
  " (in 'string', line 70, column 4 to column 38)",
  " (in 'string', line 63, column 19 to line 71, column 3)",
  " (in 'string', line 63, column 2 to line 71, column 3)",
  " (in 'string', line 73, column 2 to column 32)",
  " (in 'string', line 74, column 2 to line 75, column 32)",
  " (in 'string', line 76, column 2 to column 48)",
  " (in 'string', line 77, column 2 to line 78, column 19)",
  " (in 'string', line 79, column 2 to column 67)",
  " (in 'string', line 80, column 2 to line 81, column 41)",
  " (in 'string', line 82, column 2 to column 36)",
  " (in 'string', line 21, column 2 to column 17)",
  " (in 'string', line 22, column 9 to column 10)",
  " (in 'string', line 22, column 2 to column 14)",
  " (in 'string', line 23, column 18 to column 19)",
  " (in 'string', line 23, column 2 to column 24)",
  " (in 'string', line 24, column 2 to column 17)",
  " (in 'string', line 25, column 9 to column 10)",
  " (in 'string', line 25, column 12 to column 13)",
  " (in 'string', line 25, column 2 to column 17)",
  " (in 'string', line 27, column 2 to column 19)",
  " (in 'string', line 28, column 2 to column 26)",
  " (in 'string', line 29, column 2 to column 24)",
  " (in 'string', line 30, column 2 to column 29)",
  " (in 'string', line 31, column 2 to column 27)",
  " (in 'string', line 33, column 2 to column 19)",
  " (in 'string', line 34, column 2 to column 19)",
  " (in 'string', line 35, column 8 to column 9)",
  " (in 'string', line 35, column 2 to column 28)",
  " (in 'string', line 37, column 9 to column 10)",
  " (in 'string', line 37, column 2 to column 18)",
  " (in 'string', line 38, column 2 to column 17)",
  " (in 'string', line 39, column 9 to column 10)",
  " (in 'string', line 39, column 2 to column 20)",
  " (in 'string', line 40, column 9 to column 10)",
  " (in 'string', line 40, column 2 to column 18)",
  " (in 'string', line 44, column 9 to column 10)",
  " (in 'string', line 45, column 18 to column 19)",
  " (in 'string', line 50, column 18 to column 21)",
  " (in 'string', line 51, column 8 to column 11)",
  " (in 'string', line 51, column 20 to column 23)",
  " (in 'string', line 54, column 9 to column 10)",
  " (in 'string', line 56, column 9 to column 12)",
  " (in 'string', line 87, column 9 to column 10)",
  " (in 'string', line 14, column 4 to column 20)",
  " (in 'string', line 15, column 11 to column 12)",
  " (in 'string', line 15, column 4 to column 39)",
  " (in 'string', line 16, column 11 to column 12)",
  " (in 'string', line 16, column 4 to column 74)",
  " (in 'string', line 17, column 4 to column 35)",
  " (in 'string', line 13, column 63 to line 18, column 3)"};
template <typename T0__, typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>, T2__, T3__>,-1,1>
horseshoe(const T0__& z_arg__, const T1__& lambda_arg__, const T2__& tau,
          const T3__& c2, std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>, T2__, T3__>,-1,1>
horseshoe(const T0__& z_arg__, const T1__& lambda_arg__, const T2__& tau,
          const T3__& c2, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>, T2__, T3__>;
  int current_statement__ = 0;
  const auto& z = stan::math::to_ref(z_arg__);
  const auto& lambda = stan::math::to_ref(lambda_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int K = std::numeric_limits<int>::min();
    current_statement__ = 64;
    K = stan::math::rows(z);
    current_statement__ = 65;
    stan::math::validate_non_negative_index("lambda2", "K", K);
    Eigen::Matrix<local_scalar_t__,-1,1> lambda2 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
    current_statement__ = 66;
    stan::model::assign(lambda2, stan::math::square(lambda),
      "assigning variable lambda2");
    current_statement__ = 67;
    stan::math::validate_non_negative_index("lambda_tilde", "K", K);
    Eigen::Matrix<local_scalar_t__,-1,1> lambda_tilde =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
    current_statement__ = 68;
    stan::model::assign(lambda_tilde,
      stan::math::sqrt(
        stan::math::elt_divide(stan::math::multiply(c2, lambda2),
          stan::math::add(c2,
            stan::math::multiply(stan::math::pow(tau, 2), lambda2)))),
      "assigning variable lambda_tilde");
    current_statement__ = 69;
    return stan::math::multiply(stan::math::elt_multiply(z, lambda_tilde),
             tau);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_horseshoe_MA final : public model_base_crtp<model_horseshoe_MA> {
private:
  int N;
  Eigen::Matrix<double,-1,1> Y_data__;
  Eigen::Matrix<double,-1,1> se_data__;
  int K;
  Eigen::Matrix<double,-1,-1> X_data__;
  double df;
  double df_global;
  double df_slab;
  double scale_global;
  double scale_slab;
  int N_1;
  int M_1;
  std::vector<int> J_1;
  Eigen::Matrix<double,-1,1> Z_1_1_data__;
  int prior_only;
  Eigen::Matrix<double,-1,1> means_X_data__;
  Eigen::Matrix<double,-1,1> sds_X_data__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> Y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> se{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> Z_1_1{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> means_X{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> sds_X{nullptr, 0};
public:
  ~model_horseshoe_MA() {}
  model_horseshoe_MA(stan::io::var_context& context__, unsigned int
                     random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_horseshoe_MA_namespace::model_horseshoe_MA";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 31;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 31;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 31;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 32;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 33;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      Y_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                   std::numeric_limits<double>::quiet_NaN());
      new (&Y) Eigen::Map<Eigen::Matrix<double,-1,1>>(Y_data__.data(), N);
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 33;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 33;
        pos__ = 1;
        current_statement__ = 33;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 33;
          stan::model::assign(Y, Y_flat__[(pos__ - 1)],
            "assigning variable Y", stan::model::index_uni(sym1__));
          current_statement__ = 33;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 34;
      stan::math::validate_non_negative_index("se", "N", N);
      current_statement__ = 35;
      context__.validate_dims("data initialization", "se", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      se_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                    std::numeric_limits<double>::quiet_NaN());
      new (&se) Eigen::Map<Eigen::Matrix<double,-1,1>>(se_data__.data(), N);
      {
        std::vector<local_scalar_t__> se_flat__;
        current_statement__ = 35;
        se_flat__ = context__.vals_r("se");
        current_statement__ = 35;
        pos__ = 1;
        current_statement__ = 35;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 35;
          stan::model::assign(se, se_flat__[(pos__ - 1)],
            "assigning variable se", stan::model::index_uni(sym1__));
          current_statement__ = 35;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 35;
      stan::math::check_greater_or_equal(function__, "se", se, 0);
      current_statement__ = 36;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 36;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 36;
      stan::math::check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 37;
      stan::math::validate_non_negative_index("X", "N", N);
      current_statement__ = 38;
      stan::math::validate_non_negative_index("X", "K", K);
      current_statement__ = 39;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, K,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(), N, K);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 39;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 39;
        pos__ = 1;
        current_statement__ = 39;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 39;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 39;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 39;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 40;
      context__.validate_dims("data initialization", "df", "double",
        std::vector<size_t>{});
      df = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 40;
      df = context__.vals_r("df")[(1 - 1)];
      current_statement__ = 40;
      stan::math::check_greater_or_equal(function__, "df", df, 0);
      current_statement__ = 41;
      context__.validate_dims("data initialization", "df_global", "double",
        std::vector<size_t>{});
      df_global = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 41;
      df_global = context__.vals_r("df_global")[(1 - 1)];
      current_statement__ = 41;
      stan::math::check_greater_or_equal(function__, "df_global", df_global,
        0);
      current_statement__ = 42;
      context__.validate_dims("data initialization", "df_slab", "double",
        std::vector<size_t>{});
      df_slab = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 42;
      df_slab = context__.vals_r("df_slab")[(1 - 1)];
      current_statement__ = 42;
      stan::math::check_greater_or_equal(function__, "df_slab", df_slab, 0);
      current_statement__ = 43;
      context__.validate_dims("data initialization", "scale_global",
        "double", std::vector<size_t>{});
      scale_global = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 43;
      scale_global = context__.vals_r("scale_global")[(1 - 1)];
      current_statement__ = 43;
      stan::math::check_greater_or_equal(function__, "scale_global",
        scale_global, 0);
      current_statement__ = 44;
      context__.validate_dims("data initialization", "scale_slab", "double",
        std::vector<size_t>{});
      scale_slab = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 44;
      scale_slab = context__.vals_r("scale_slab")[(1 - 1)];
      current_statement__ = 44;
      stan::math::check_greater_or_equal(function__, "scale_slab",
        scale_slab, 0);
      current_statement__ = 45;
      context__.validate_dims("data initialization", "N_1", "int",
        std::vector<size_t>{});
      N_1 = std::numeric_limits<int>::min();
      current_statement__ = 45;
      N_1 = context__.vals_i("N_1")[(1 - 1)];
      current_statement__ = 45;
      stan::math::check_greater_or_equal(function__, "N_1", N_1, 1);
      current_statement__ = 46;
      context__.validate_dims("data initialization", "M_1", "int",
        std::vector<size_t>{});
      M_1 = std::numeric_limits<int>::min();
      current_statement__ = 46;
      M_1 = context__.vals_i("M_1")[(1 - 1)];
      current_statement__ = 46;
      stan::math::check_greater_or_equal(function__, "M_1", M_1, 1);
      current_statement__ = 47;
      stan::math::validate_non_negative_index("J_1", "N", N);
      current_statement__ = 48;
      context__.validate_dims("data initialization", "J_1", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      J_1 = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 48;
      J_1 = context__.vals_i("J_1");
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "J_1", J_1, 1);
      current_statement__ = 49;
      stan::math::validate_non_negative_index("Z_1_1", "N", N);
      current_statement__ = 50;
      context__.validate_dims("data initialization", "Z_1_1", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      Z_1_1_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                       std::numeric_limits<double>::quiet_NaN());
      new (&Z_1_1)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(Z_1_1_data__.data(), N);
      {
        std::vector<local_scalar_t__> Z_1_1_flat__;
        current_statement__ = 50;
        Z_1_1_flat__ = context__.vals_r("Z_1_1");
        current_statement__ = 50;
        pos__ = 1;
        current_statement__ = 50;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 50;
          stan::model::assign(Z_1_1, Z_1_1_flat__[(pos__ - 1)],
            "assigning variable Z_1_1", stan::model::index_uni(sym1__));
          current_statement__ = 50;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 51;
      context__.validate_dims("data initialization", "prior_only", "int",
        std::vector<size_t>{});
      prior_only = std::numeric_limits<int>::min();
      current_statement__ = 51;
      prior_only = context__.vals_i("prior_only")[(1 - 1)];
      current_statement__ = 52;
      stan::math::validate_non_negative_index("means_X", "K", K);
      current_statement__ = 53;
      context__.validate_dims("data initialization", "means_X", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      means_X_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                         std::numeric_limits<double>::quiet_NaN());
      new (&means_X)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(means_X_data__.data(), K);
      {
        std::vector<local_scalar_t__> means_X_flat__;
        current_statement__ = 53;
        means_X_flat__ = context__.vals_r("means_X");
        current_statement__ = 53;
        pos__ = 1;
        current_statement__ = 53;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 53;
          stan::model::assign(means_X, means_X_flat__[(pos__ - 1)],
            "assigning variable means_X", stan::model::index_uni(sym1__));
          current_statement__ = 53;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 54;
      stan::math::validate_non_negative_index("sds_X", "K", K);
      current_statement__ = 55;
      context__.validate_dims("data initialization", "sds_X", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      sds_X_data__ = Eigen::Matrix<double,-1,1>::Constant(K,
                       std::numeric_limits<double>::quiet_NaN());
      new (&sds_X)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(sds_X_data__.data(), K);
      {
        std::vector<local_scalar_t__> sds_X_flat__;
        current_statement__ = 55;
        sds_X_flat__ = context__.vals_r("sds_X");
        current_statement__ = 55;
        pos__ = 1;
        current_statement__ = 55;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 55;
          stan::model::assign(sds_X, sds_X_flat__[(pos__ - 1)],
            "assigning variable sds_X", stan::model::index_uni(sym1__));
          current_statement__ = 55;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 56;
      stan::math::validate_non_negative_index("zb", "K", K);
      current_statement__ = 57;
      stan::math::validate_non_negative_index("hs_local", "K", K);
      current_statement__ = 58;
      stan::math::validate_non_negative_index("sd_1", "M_1", M_1);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("z_1", "M_1", M_1);
      current_statement__ = 60;
      stan::math::validate_non_negative_index("z_1", "N_1", N_1);
      current_statement__ = 61;
      stan::math::validate_non_negative_index("b", "K", K);
      current_statement__ = 62;
      stan::math::validate_non_negative_index("r_1_1", "N_1", N_1);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("betas", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = K + K + 1 + 1 + 1 + M_1 + (M_1 * N_1);
  }
  inline std::string model_name() const final {
    return "model_horseshoe_MA";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_horseshoe_MA_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> zb =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 1;
      zb = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      Eigen::Matrix<local_scalar_t__,-1,1> hs_local =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 2;
      hs_local = in__.template read_constrain_lb<
                   Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
                   K);
      local_scalar_t__ Int_c = DUMMY_VAR__;
      current_statement__ = 3;
      Int_c = in__.template read<local_scalar_t__>();
      local_scalar_t__ hs_global = DUMMY_VAR__;
      current_statement__ = 4;
      hs_global = in__.template read_constrain_lb<local_scalar_t__,
                    jacobian__>(0, lp__);
      local_scalar_t__ hs_slab = DUMMY_VAR__;
      current_statement__ = 5;
      hs_slab = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> sd_1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(M_1, DUMMY_VAR__);
      current_statement__ = 6;
      sd_1 = in__.template read_constrain_lb<
               Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
               M_1);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> z_1 =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(M_1,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N_1, DUMMY_VAR__));
      current_statement__ = 7;
      z_1 = in__.template read<
              std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>>(M_1, N_1);
      Eigen::Matrix<local_scalar_t__,-1,1> b =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 9;
      sigma = 0;
      Eigen::Matrix<local_scalar_t__,-1,1> r_1_1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N_1, DUMMY_VAR__);
      current_statement__ = 14;
      stan::model::assign(b,
        horseshoe(zb, hs_local, hs_global, (stan::math::pow(scale_slab, 2) *
          hs_slab), pstream__), "assigning variable b");
      current_statement__ = 15;
      stan::model::assign(r_1_1,
        stan::math::multiply(
          stan::model::rvalue(sd_1, "sd_1", stan::model::index_uni(1)),
          stan::model::rvalue(z_1, "z_1", stan::model::index_uni(1))),
        "assigning variable r_1_1");
      current_statement__ = 9;
      stan::math::check_greater_or_equal(function__, "sigma", sigma, 0);
      {
        current_statement__ = 23;
        if (stan::math::logical_negation(prior_only)) {
          current_statement__ = 16;
          stan::math::validate_non_negative_index("mu", "N", N);
          Eigen::Matrix<local_scalar_t__,-1,1> mu =
            Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
          current_statement__ = 17;
          stan::model::assign(mu,
            stan::math::add(Int_c, stan::math::multiply(X, b)),
            "assigning variable mu");
          current_statement__ = 20;
          for (int n = 1; n <= N; ++n) {
            current_statement__ = 18;
            stan::model::assign(mu,
              (stan::model::rvalue(mu, "mu", stan::model::index_uni(n)) +
              (stan::model::rvalue(r_1_1, "r_1_1",
                 stan::model::index_uni(
                   stan::model::rvalue(J_1, "J_1", stan::model::index_uni(n))))
              *
              stan::model::rvalue(Z_1_1, "Z_1_1", stan::model::index_uni(n)))),
              "assigning variable mu", stan::model::index_uni(n));
          }
          current_statement__ = 21;
          lp_accum__.add(stan::math::normal_lpdf<false>(Y, mu, se));
        }
        current_statement__ = 24;
        lp_accum__.add(stan::math::std_normal_lpdf<false>(zb));
        current_statement__ = 25;
        lp_accum__.add((stan::math::student_t_lpdf<false>(hs_local, df, 0, 1)
          - (stan::math::rows(hs_local) * stan::math::log(0.5))));
        current_statement__ = 26;
        lp_accum__.add(stan::math::student_t_lpdf<false>(Int_c, 3, 0.1, 2.5));
        current_statement__ = 27;
        lp_accum__.add((stan::math::student_t_lpdf<false>(hs_global,
                          df_global, 0, scale_global) - (1 *
          stan::math::log(0.5))));
        current_statement__ = 28;
        lp_accum__.add(stan::math::inv_gamma_lpdf<false>(hs_slab, (0.5 *
                         df_slab), (0.5 * df_slab)));
        current_statement__ = 29;
        lp_accum__.add((stan::math::student_t_lpdf<false>(sd_1, 3, 0, 2.5) -
          (1 * stan::math::student_t_lccdf(0, 3, 0, 2.5))));
        current_statement__ = 30;
        lp_accum__.add(stan::math::std_normal_lpdf<false>(
                         stan::model::rvalue(z_1, "z_1",
                           stan::model::index_uni(1))));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_horseshoe_MA_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> zb =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      zb = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      Eigen::Matrix<double,-1,1> hs_local =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      hs_local = in__.template read_constrain_lb<
                   Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
                   K);
      double Int_c = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      Int_c = in__.template read<local_scalar_t__>();
      double hs_global = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      hs_global = in__.template read_constrain_lb<local_scalar_t__,
                    jacobian__>(0, lp__);
      double hs_slab = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 5;
      hs_slab = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> sd_1 =
        Eigen::Matrix<double,-1,1>::Constant(M_1,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 6;
      sd_1 = in__.template read_constrain_lb<
               Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
               M_1);
      std::vector<Eigen::Matrix<double,-1,1>> z_1 =
        std::vector<Eigen::Matrix<double,-1,1>>(M_1,
          Eigen::Matrix<double,-1,1>::Constant(N_1,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 7;
      z_1 = in__.template read<
              std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>>(M_1, N_1);
      Eigen::Matrix<double,-1,1> b =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      double sigma = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,1> r_1_1 =
        Eigen::Matrix<double,-1,1>::Constant(N_1,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(zb);
      out__.write(hs_local);
      out__.write(Int_c);
      out__.write(hs_global);
      out__.write(hs_slab);
      out__.write(sd_1);
      for (int sym1__ = 1; sym1__ <= N_1; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= M_1; ++sym2__) {
          out__.write(z_1[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 9;
      sigma = 0;
      current_statement__ = 14;
      stan::model::assign(b,
        horseshoe(zb, hs_local, hs_global, (stan::math::pow(scale_slab, 2) *
          hs_slab), pstream__), "assigning variable b");
      current_statement__ = 15;
      stan::model::assign(r_1_1,
        stan::math::multiply(
          stan::model::rvalue(sd_1, "sd_1", stan::model::index_uni(1)),
          stan::model::rvalue(z_1, "z_1", stan::model::index_uni(1))),
        "assigning variable r_1_1");
      current_statement__ = 9;
      stan::math::check_greater_or_equal(function__, "sigma", sigma, 0);
      if (emit_transformed_parameters__) {
        out__.write(b);
        out__.write(sigma);
        out__.write(r_1_1);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      double Intercept = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 11;
      Intercept = (Int_c -
        stan::math::sum(
          stan::math::elt_multiply(b, stan::math::elt_divide(means_X, sds_X))));
      Eigen::Matrix<double,-1,1> betas =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 12;
      stan::model::assign(betas, stan::math::elt_divide(b, sds_X),
        "assigning variable betas");
      double tau2 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 13;
      tau2 = stan::math::pow(
               stan::model::rvalue(sd_1, "sd_1", stan::model::index_uni(1)),
               2);
      out__.write(Intercept);
      out__.write(betas);
      out__.write(tau2);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> zb =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(zb,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable zb");
      out__.write(zb);
      Eigen::Matrix<local_scalar_t__,-1,1> hs_local =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(hs_local,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable hs_local");
      out__.write_free_lb(0, hs_local);
      local_scalar_t__ Int_c = DUMMY_VAR__;
      current_statement__ = 3;
      Int_c = in__.read<local_scalar_t__>();
      out__.write(Int_c);
      local_scalar_t__ hs_global = DUMMY_VAR__;
      current_statement__ = 4;
      hs_global = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, hs_global);
      local_scalar_t__ hs_slab = DUMMY_VAR__;
      current_statement__ = 5;
      hs_slab = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, hs_slab);
      Eigen::Matrix<local_scalar_t__,-1,1> sd_1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(M_1, DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(sd_1,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(M_1),
        "assigning variable sd_1");
      out__.write_free_lb(0, sd_1);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> z_1 =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(M_1,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N_1, DUMMY_VAR__));
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N_1; ++sym1__) {
        current_statement__ = 7;
        for (int sym2__ = 1; sym2__ <= M_1; ++sym2__) {
          current_statement__ = 7;
          stan::model::assign(z_1, in__.read<local_scalar_t__>(),
            "assigning variable z_1", stan::model::index_uni(sym2__),
            stan::model::index_uni(sym1__));
        }
      }
      out__.write(z_1);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "zb", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "hs_local",
        "double", std::vector<size_t>{static_cast<size_t>(K)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "Int_c", "double",
        std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "hs_global",
        "double", std::vector<size_t>{});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "hs_slab",
        "double", std::vector<size_t>{});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "sd_1", "double",
        std::vector<size_t>{static_cast<size_t>(M_1)});
      current_statement__ = 7;
      context__.validate_dims("parameter initialization", "z_1", "double",
        std::vector<size_t>{static_cast<size_t>(M_1),
          static_cast<size_t>(N_1)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> zb =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> zb_flat__;
        current_statement__ = 1;
        zb_flat__ = context__.vals_r("zb");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(zb, zb_flat__[(pos__ - 1)],
            "assigning variable zb", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(zb);
      Eigen::Matrix<local_scalar_t__,-1,1> hs_local =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> hs_local_flat__;
        current_statement__ = 2;
        hs_local_flat__ = context__.vals_r("hs_local");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(hs_local, hs_local_flat__[(pos__ - 1)],
            "assigning variable hs_local", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, hs_local);
      local_scalar_t__ Int_c = DUMMY_VAR__;
      current_statement__ = 3;
      Int_c = context__.vals_r("Int_c")[(1 - 1)];
      out__.write(Int_c);
      local_scalar_t__ hs_global = DUMMY_VAR__;
      current_statement__ = 4;
      hs_global = context__.vals_r("hs_global")[(1 - 1)];
      out__.write_free_lb(0, hs_global);
      local_scalar_t__ hs_slab = DUMMY_VAR__;
      current_statement__ = 5;
      hs_slab = context__.vals_r("hs_slab")[(1 - 1)];
      out__.write_free_lb(0, hs_slab);
      Eigen::Matrix<local_scalar_t__,-1,1> sd_1 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(M_1, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> sd_1_flat__;
        current_statement__ = 6;
        sd_1_flat__ = context__.vals_r("sd_1");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= M_1; ++sym1__) {
          current_statement__ = 6;
          stan::model::assign(sd_1, sd_1_flat__[(pos__ - 1)],
            "assigning variable sd_1", stan::model::index_uni(sym1__));
          current_statement__ = 6;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, sd_1);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> z_1 =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(M_1,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N_1, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> z_1_flat__;
        current_statement__ = 7;
        z_1_flat__ = context__.vals_r("z_1");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= N_1; ++sym1__) {
          current_statement__ = 7;
          for (int sym2__ = 1; sym2__ <= M_1; ++sym2__) {
            current_statement__ = 7;
            stan::model::assign(z_1, z_1_flat__[(pos__ - 1)],
              "assigning variable z_1", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 7;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(z_1);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"zb", "hs_local", "Int_c",
                "hs_global", "hs_slab", "sd_1", "z_1"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"b", "sigma", "r_1_1"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"Intercept", "betas", "tau2"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(K)},
                std::vector<size_t>{static_cast<size_t>(K)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(M_1)},
                std::vector<size_t>{static_cast<size_t>(M_1),
                  static_cast<size_t>(N_1)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(K)},
             std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(N_1)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(K)},
             std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "zb" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "hs_local" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "Int_c");
    param_names__.emplace_back(std::string() + "hs_global");
    param_names__.emplace_back(std::string() + "hs_slab");
    for (int sym1__ = 1; sym1__ <= M_1; ++sym1__) {
      param_names__.emplace_back(std::string() + "sd_1" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= N_1; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= M_1; ++sym2__) {
        param_names__.emplace_back(std::string() + "z_1" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        param_names__.emplace_back(std::string() + "b" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "sigma");
      for (int sym1__ = 1; sym1__ <= N_1; ++sym1__) {
        param_names__.emplace_back(std::string() + "r_1_1" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "Intercept");
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        param_names__.emplace_back(std::string() + "betas" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "tau2");
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "zb" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "hs_local" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "Int_c");
    param_names__.emplace_back(std::string() + "hs_global");
    param_names__.emplace_back(std::string() + "hs_slab");
    for (int sym1__ = 1; sym1__ <= M_1; ++sym1__) {
      param_names__.emplace_back(std::string() + "sd_1" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= N_1; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= M_1; ++sym2__) {
        param_names__.emplace_back(std::string() + "z_1" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        param_names__.emplace_back(std::string() + "b" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "sigma");
      for (int sym1__ = 1; sym1__ <= N_1; ++sym1__) {
        param_names__.emplace_back(std::string() + "r_1_1" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "Intercept");
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        param_names__.emplace_back(std::string() + "betas" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "tau2");
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"zb\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"hs_local\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"Int_c\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_global\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_slab\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sd_1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(M_1) + "},\"block\":\"parameters\"},{\"name\":\"z_1\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(M_1) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_1) + "}},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"r_1_1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_1) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Intercept\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"betas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"generated_quantities\"},{\"name\":\"tau2\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"zb\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"hs_local\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"Int_c\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_global\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_slab\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sd_1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(M_1) + "},\"block\":\"parameters\"},{\"name\":\"z_1\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(M_1) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_1) + "}},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"r_1_1\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_1) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Intercept\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"betas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"generated_quantities\"},{\"name\":\"tau2\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((K + K) + 1) + 1) + 1) + M_1) + (M_1 *
      N_1));
    const size_t num_transformed = emit_transformed_parameters * (((K + 1) +
      N_1));
    const size_t num_gen_quantities = emit_generated_quantities * (((1 + K) +
      1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((K + K) + 1) + 1) + 1) + M_1) + (M_1 *
      N_1));
    const size_t num_transformed = emit_transformed_parameters * (((K + 1) +
      N_1));
    const size_t num_gen_quantities = emit_generated_quantities * (((1 + K) +
      1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_horseshoe_MA_namespace::model_horseshoe_MA;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_horseshoe_MA_namespace::profiles__;
}
#endif
#endif
