% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_mask.R
\name{maskPed}
\alias{maskPed}
\alias{unmaskPed}
\title{Mask and unmask pedigree datasets}
\usage{
maskPed(
  x,
  ids = NULL,
  markerNames = NULL,
  markerShuffle = TRUE,
  alleleLabels = NULL,
  alleleShuffle = TRUE,
  seed = NULL
)

unmaskPed(x, keys)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{ids}{(Optional) A named character with the new IDs, written as \code{c(old = new, ...)}. By default: 1, 2, ... .}

\item{markerNames}{(Optional) A named character with the new marker names
(and order), written as \code{c(old = new, ...)}. By default: M1, M2, ... .}

\item{markerShuffle}{A logical: Randomly reorder the markers? (Default: TRUE)}

\item{alleleLabels}{(Optional) A list of character vectors. The list names
should be the original marker names. Each vector gives the new allele
labels, as \code{c(old = new, ...)}. By default, each marker gets alleles 1, 2,
... .}

\item{alleleShuffle}{A logical: Randomly reorder the alleles? (Default: TRUE)}

\item{seed}{An optional seed for the random number generator.}

\item{keys}{A list with entries \code{ids}, \code{markerNames}, \code{alleleLabels}.}
}
\value{
An object similar to \code{x} but with replaced ID labels, marker names
and allele labels.
}
\description{
The \code{maskPed()} function replaces the individual IDs, marker names and allele
names with generic labels, and randomly changes their internal order. For
markers with stepwise mutation models, the allelic ladder is simply
translated to start at 1, thereby preserving the intra-allelic differences.
}
\details{
Note that in order to preserve likelihoods, the allele frequencies are not
modified. Thus, if the data uses a publicly available frequency databases,
the result cannot be considered to be fully anonymised, since one could (at
least in theory) deduce the original marker names and alleles from the
frequencies.)
}
\examples{
x = nuclearPed(father = "fa", mother = "mo", children = "ch") |>
  addMarker(name = "myMarker", ch = "b/c", afreq = c(a=0.2, b=0.3, c=0.5)) |>
  setMutmod(model = "proportional", rate = 0.01)

# Mask
y = maskPed(x, seed = 1729)

# Unmask
z = unmaskPed(y$maskedPed, keys = y$keys)
stopifnot(identical(x, z))

# With stepwise model
x2 = x |>
  addMarker(name = "mySTR", ch = "7.2/8.2",
            alleles = c("7", "7.2", "8", "8.2")) |>
  setMutmod(marker = 2, model = "stepwise", rate = 0.1, rate2 = 1e-6,
            range = 0.1)

y2 = maskPed(x2, seed = 1729)

z2 = unmaskPed(y2$maskedPed, keys = y2$keys)

stopifnot(identical(x2, z2))

# Check likelihoods with pedprobr:
# stopifnot(setequal(likelihood(x2), likelihood(y2$maskedPed)))

}
