% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_gwcode_to_cow.R
\name{add_gwcode_to_cow}
\alias{add_gwcode_to_cow}
\title{Add Gleditsch-Ward state system codes to your data with Correlates of War state codes.}
\usage{
add_gwcode_to_cow(data)
}
\arguments{
\item{data}{a data frame with appropriate \pkg{peacesciencer} attributes}
}
\value{
\code{add_gwcode_to_cow()} takes a (dyad-year, leader-year, leader-dyad-year,
state-year) data frame that already has Correlates of War state system codes
and adds their corollary Gleditsch-Ward codes.
}
\description{
\code{add_gwcode_to_cow()} allows you to match, as well as one can, Gleditsch-Ward system membership data
with Correlates of War state system membership data.
}
\details{
As of version 1.2, this function leans on the information made available in
the \pkg{isard} package. This is a spin-off package I maintain for data that
require periodic updates for the functionality in this package. As of writing,
\pkg{peacesciencer} only requires that you have the \pkg{isard} package
installed. It does not require you to have any particular version of the
package installed. Thus, what exactly this function returns may depend on the
particular version of \pkg{isard} you have installed. This will assuredly
concern the right-bound of the temporal domain of data you get.

You can read more about the data in the documentation for \pkg{isard}.
\itemize{
\item \url{https://svmiller.com/isard/reference/cw_gw_panel.html}
}

The user will invariably need to be careful and ask why they want
these data included. The issue here is that both have a different
composition and the merging process will not (and cannot) be perfect.
We can note that a case like Serbia/Yugoslavia is not too difficult
to handle (since "Serbia" never overlaps with "Yugoslavia" in the
Gleditsch-Ward data and Correlates of War understands Serbia as the
predecessor state, dominant state, and successor state to Yugoslavia).
However, there is greater weirdness with a case like Yemen/Yemen
Arab Republic. The script will \emph{not} create state-year or dyad-year
duplicates for the Correlates of War codes. The size of the original data
remain unchanged. However, there will be some year duplicates for various
Gleditsch-Ward codes (e.g. Yemen, again). Use with care. You can also use
the \pkg{countrycode} package. Whether you use this function or the
\pkg{countrycode} package, do \emph{not} do this kind of merging without
assessing the output.
}
\examples{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)

cow_ddy \%>\% add_gwcode_to_cow()

create_stateyears() \%>\% add_gwcode_to_cow()


}
\author{
Steven V. Miller
}
