% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tx_to_coding}
\alias{tx_to_coding}
\title{Convert codes to Coding structures}
\usage{
tx_to_coding(coding_column, system, version = NULL)
}
\arguments{
\item{coding_column}{The Column containing the codes.}

\item{system}{The URI of the system the codes belong to.}

\item{version}{The version of the code system.}
}
\value{
A Column containing a Coding struct.
}
\description{
Converts a Column containing codes into a Column that contains a Coding struct.
}
\details{
The Coding struct Column can be used as an input to terminology functions such as 
\code{\link{tx_member_of}} and \code{\link{tx_translate}}. Please note that inside 
\code{sparklyr} verbs such as \code{mutate} the functions calls need to be preceded with 
\code{!!}, e.g: \code{!!tx_to_coding(CODE, SNOMED_URI)}.
}
\examples{
\dontrun{
condition_df <- pathling_spark(pc) \%>\% sparklyr::copy_to(conditions)

# Convert codes to ICD-10 codings.
condition_df \%>\% sparklyr::mutate(
    icdCoding = !!tx_to_coding(CODE, "http://hl7.org/fhir/sid/icd-10"), .keep = 'none'
)
}
}
\seealso{
\href{https://hl7.org/fhir/R4/datatypes.html#Coding}{FHIR R4 - Coding}

Other terminology helpers: 
\code{\link{tx_to_ecl_value_set}()},
\code{\link{tx_to_loinc_coding}()},
\code{\link{tx_to_snomed_coding}()}
}
\concept{terminology helpers}
