% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_reg_gee.R
\name{details_linear_reg_gee}
\alias{details_linear_reg_gee}
\title{Linear regression via generalized estimating equations (GEE)}
\description{
\code{gee::gee()} uses generalized least squares to fit different types of models
with errors that are not independent.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has no formal tuning parameters. It may be beneficial to
determine the appropriate correlation structure to use, but this
typically does not affect the predicted value of the model. It \emph{does}
have an effect on the inferential results and parameter covariance
values.
}

\subsection{Translation from parsnip to the original package}{

The \strong{multilevelmod} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(multilevelmod)

linear_reg() |> 
  set_engine("gee") |> 
  set_mode("regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Linear Regression Model Specification (regression)
## 
## Computational engine: gee 
## 
## Model fit template:
## multilevelmod::gee_fit(formula = missing_arg(), data = missing_arg(), 
##     family = gaussian)
}\if{html}{\out{</div>}}

\code{multilevelmod::gee_fit()} is a wrapper model around \code{gee::gee()}.
}

\subsection{Preprocessing requirements}{

There are no specific preprocessing needs. However, it is helpful to
keep the clustering/subject identifier column as factor or character
(instead of making them into dummy variables). See the examples in the
next section.
}

\subsection{Other details}{

The model cannot accept case weights.

Both \code{gee:gee()} and \code{gee:geepack()} specify the id/cluster variable
using an argument \code{id} that requires a vector. parsnip doesn’t work that
way so we enable this model to be fit using a artificial function
\code{id_var()} to be used in the formula. So, in the original package, the
call would look like:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gee(breaks ~ tension, id = wool, data = warpbreaks, corstr = "exchangeable")
}\if{html}{\out{</div>}}

With parsnip, we suggest using the formula method when fitting:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)

linear_reg() |> 
  set_engine("gee", corstr = "exchangeable") |> 
  fit(breaks ~ tension + id_var(wool), data = warpbreaks)
}\if{html}{\out{</div>}}

When using tidymodels infrastructure, it may be better to use a
workflow. In this case, you can add the appropriate columns using
\code{add_variables()} then supply the GEE formula when adding the model:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(tidymodels)

gee_spec <- 
  linear_reg() |> 
  set_engine("gee", corstr = "exchangeable")

gee_wflow <- 
  workflow() |> 
  # The data are included as-is using:
  add_variables(outcomes = breaks, predictors = c(tension, wool)) |> 
  add_model(gee_spec, formula = breaks ~ tension + id_var(wool))

fit(gee_wflow, data = warpbreaks)
}\if{html}{\out{</div>}}

The \code{gee::gee()} function always prints out warnings and output even
when \code{silent = TRUE}. The parsnip \code{"gee"} engine, by contrast, silences
all console output coming from \code{gee::gee()}, even if \code{silent = FALSE}.

Also, because of issues with the \code{gee()} function, a supplementary call
to \code{glm()} is needed to get the rank and QR decomposition objects so
that \code{predict()} can be used.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item Liang, K.Y. and Zeger, S.L. (1986) Longitudinal data analysis using
generalized linear models. \emph{Biometrika}, 73 13–22.
\item Zeger, S.L. and Liang, K.Y. (1986) Longitudinal data analysis for
discrete and continuous outcomes. \emph{Biometrics}, 42 121–130.
}
}
}
\keyword{internal}
