% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_modify.R
\name{rmd_modify}
\alias{rmd_modify}
\title{Modify nodes of an Rmd ast}
\usage{
rmd_modify(x, .f, ...)
}
\arguments{
\item{x}{Rmd object, e.g. \code{rmd_ast} or \code{rmd_tibble}.}

\item{.f}{A function to apply to the selected nodes. Must return a valid rmd node object.}

\item{...}{Selection arguments (unnamed) and function arguments (named).
Unnamed arguments are used for node selection using tidyselect syntax.
Named arguments are passed to the function \code{.f}.}
}
\value{
Returns the modified Rmd object (either \code{rmd_ast} or \code{rmd_tibble} depending on input).
Only the selected nodes are modified by applying \code{.f}, while unselected nodes remain unchanged.
}
\description{
This function applies a function to selected nodes of an \code{rmd_ast} or \code{rmd_tibble}.
The selection is implemented using the same approach as \code{\link[=rmd_select]{rmd_select()}} which enables
a variety of useful syntax for selecting nodes from the ast.

The function \code{.f} must return a valid rmd node object (e.g., \code{rmd_chunk}, \code{rmd_heading}, etc.).
The results are validated to ensure they maintain the proper structure and class.
}
\examples{
rmd = parse_rmd(system.file("examples/hw01.Rmd", package = "parsermd"))

# Modify specific chunks by label
f = function(node) { # Add a comment to the chunk
  node@code = c("# Modified chunk", node@code)
  node
}
rmd_modify(rmd, .f = f, "plot-dino") |>
  rmd_select("plot-dino") |>
  as_document() |>
  cat(sep="\n")

# Modify all chunks with named arguments passed to function
f = function(node, prefix = "## ") {
  node@code = paste0(prefix, node@code)
  node
}
rmd_modify(rmd, f, has_type("rmd_chunk"), prefix = "# ") |>
 rmd_select(has_type("rmd_chunk")) |>
 as_document() |>
 cat(sep="\n")

}
