% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_defunct.R
\name{fetch_zotero_refs}
\alias{fetch_zotero_refs}
\title{Save a collection from a Zotero-Account to a BibTeX-file (defunct)}
\usage{
fetch_zotero_refs(
  x,
  bib_name,
  API_key = NULL,
  collection = NULL,
  lib_type = "user"
)
}
\arguments{
\item{x}{Character. Zotero user or group ID, see details.}

\item{bib_name}{Character. Name of the BibTeX-file references are saved to.}

\item{API_key}{Character. Zotero API key, see details.}

\item{collection}{Character. Optional ID of a collection in the Zotero
library, see details.}

\item{lib_type}{Character. Specifies if the supplied ID is associated with a
Zotero \code{user} or \code{group}.}
}
\value{
Returns \code{bib_name} invisibly.
}
\description{
Downloads and saves a Zotero reference library (or a subset) and saves it as
BibTeX file. \emph{This function has been defunct. Use \code{ReadZotero()} from the
\pkg{RefManageR} package instead.}
}
\details{
This function retrieves references through the Zotero web API. \code{x}
takes a Zotero user or group ID that can be retrieved from the Zotero.org
user or group Feeds/API settings.
An authentication key (\code{API_key}) is required to access nonpublic
Zotero libraries. Authentication keys can also be generated in the
Zotero.org user or group Feeds/API settings.

If the requested reference collection is larger than 100 records, multiple
API calls are initiated because the number of retrieved records is limited
to 100 per API call. Frequent API calls will result in a temporary access
block. Thus, there is an (currently unknown) upper limit to the length of
reference collections that can be retrieved through this function. It is
generally recommended to comment out calls to this function in R
Markdown documents during periods of frequent knitting to limit the number
of API calls and limit the number of references to those needed for the
current document by setting up collections in your Zotero library.

Collection keys (\code{collection}), i.e. identifiers of reference library
subsets, can be retrieved by accessing them via a web browser. They keys
are contained in the URL:

\verb{https://www.zotero.org/<USERNAME>/items/collectionKey/<COLLECTIONKEY>}

Zotero web API calls can be slow, especially for large reference
collections. If available, this function will use the
\pkg{downloader}-package, which speeds up reference downloads considerably.
}
\seealso{
\code{\link[=cite_r]{cite_r()}}, \code{\link[=r_refs]{r_refs()}}
}
\author{
Christoph Stahl, Frederik Aust
}
