% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_reference}
\alias{pbdb_reference}
\title{Get information about a single reference}
\usage{
pbdb_reference(id, ...)
}
\arguments{
\item{id}{Identifier of the reference. This parameter is required.}

\item{...}{Arguments passed to the API. See documentation for
accepted parameters at
\url{https://paleobiodb.org/data1.2/refs/single}. E.g.:
\itemize{
\item \code{vocab}: Set to \code{"pbdb"} to show the complete name of the
variables (by default variables have short 3-letter names).
\item \code{show}: Additional information to be shown along with the basic
record.  Some possible values include:
\itemize{
\item \code{counts}: Report the number of taxonomic names, opinions,
occurrences, specimens, and collections derived from this
reference that have been entered into the database.
\item \code{both}: Show both the formatted reference and the individual
fields.
}
}}
}
\value{
A data frame with a single reference.
}
\description{
Returns information about a single reference, selected by
identifier.
}
\examples{
\dontrun{
  pbdb_reference(id = 1003, vocab = "pbdb", show = "both")
}
}
