% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.mat.R
\name{multi.mat}
\alias{multi.mat}
\title{MAT for multiple variables}
\usage{
multi.mat(
  training.spp,
  envs,
  core.spp,
  noanalogues = 10,
  method = "sq-chord",
  run = "both"
)
}
\arguments{
\item{training.spp}{Community data}

\item{envs}{Environmental variables - or simulations}

\item{core.spp}{Optional fossil data to make predictions for}

\item{noanalogues}{Number of analogues to use}

\item{method}{distance metric to use}

\item{run}{Return LOO predictions or predictions for fossil data}
}
\value{
If \code{run = "both"}, a list with two elements:
\item{jack}{ Matrix of leave-one-out cross-validation predictions for the
calibration set}
\item{core}{ Matrix of predictions for the fossil data}
Otherwise, one of these matrices is returned.
}
\description{
MAT for many environmental variables simultaneously.
More efficient than calculating them separately for each variable.
}
\examples{
data(arctic.env)
data(arctic.pollen)

mMAT <- multi.mat(arctic.pollen, arctic.env[, 9:67], noanalogues = 5)
}
\references{
Telford, R. J. and Birks, H. J. B. (2009) Evaluation of transfer functions in
spatially structured environments. \emph{Quaternary Science Reviews}
\bold{28}: 1309--1316. \doi{10.1016/j.quascirev.2008.12.020}
}
\author{
Richard Telford \email{Richard.Telford@bio.uib.no}
}
\keyword{multivariate}
