% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pecv.R
\name{generate_continuous_data}
\alias{generate_continuous_data}
\title{Generate continuous data example}
\usage{
generate_continuous_data(n = 100, p = 50, q = 3, noise_sd = 1)
}
\arguments{
\item{n}{Integer. Number of observations.}

\item{p}{Integer. Number of variables.}

\item{q}{Integer. True number of latent factors.}

\item{noise_sd}{Numeric. Standard deviation of Gaussian noise.}
}
\value{
A named list with components:
\describe{
  \item{resp}{Numeric matrix (n x p). Generated observed data.}
  \item{true_q}{Integer. True number of factors used in simulation.}
  \item{theta_true}{Numeric matrix (n x (q+1)). True latent factor scores with intercept.}
  \item{A_true}{Numeric matrix (p x (q+1)). True factor loadings.}
}
}
\description{
Generate simulated data from a Gaussian factor model.
}
