% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNullDistribution.R
\name{plotNullDistribution}
\alias{plotNullDistribution}
\title{Plot permutation \eqn{p}-values distribution}
\usage{
plotNullDistribution(P=NULL,family="simes",alpha = 0.05, 
path = getwd(), name = "plot", delta = 0,
copes=NULL,mask=NULL, alternative = "two.sided", rand = FALSE, B = 1000)
}
\arguments{
\item{P}{Matrix of \eqn{p}-values with dimensions \eqn{m \times B} where \eqn{m} is the number of variables 
and \eqn{B} the number of permutations used instead of the data matrix \code{X}. Default to \code{NULL}.}

\item{family}{String character. Name of the family confidence envelope to compute the critical vector 
from \code{"simes"}, \code{"aorc"}, \code{"beta"}, \code{"higher.criticism"}, and \code{"power"}.
Default to "simes". If more than one critical vector are considered, it must be a vector.}

\item{alpha}{Numeric value in `[0,1]`. \eqn{\alpha} level to control the family-wise error rate. Default to 0.05.}

\item{path}{Character string. Path to save the plot. The path does not must end with \code{/}. Default to \code{getwd()}.}

\item{name}{Character string. The name of file that will be used to save the plot. Default to "plot".}

\item{delta}{Numeric value. \eqn{\delta} value. Please see the reference below. Default to 0. 
If more than one critical vector are considered, \code{delta} must be a vector having length equals to the length of the vector specified in \code{family}.}

\item{copes}{List of NIfTI file. The list of copes, i.e., contrasts maps, one for each subject used to compute the statistical tests.}

\item{mask}{NIfTI file or character string. 3D array of logical values (i.e. \code{TRUE/FALSE} in/out of the brain). 
Alternatively it may be a (character) NIfTI file name. If \code{mask=NULL}, it is assumed that none of the voxels have to be excluded.}

\item{alternative}{Character string. It refers to the alternative hypothesis, must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"lower"}.}

\item{rand}{Boolean value. Default to \code{FALSE}. If \code{rand = TRUE}, the \eqn{p}-values are computed by \code{rowRanks}.}

\item{B}{Numeric value. Number of permutations, default to 1000.}
}
\value{
Save a plot in \code{path} with name specified in \code{name} describing the \eqn{p}-values null distribution with critical value curve and observed \eqn{p}-values in red.
}
\description{
Create a plot of permutation-based \eqn{p}-values with corresponding specified critical vectors.
}
\examples{
\dontrun{
db <- simulateData(pi0 = 0.8, m = 100, n = 20, rho = 0)
out <- signTest(X = db)
pv <- cbind(out$pv, out$pv_H0)
plotNullDistribution(P = pv)
}

}
\references{
Andreella, A., Hemerik, J., Finos, L., Weeda, W., & Goeman, J. (2023). Permutation-based true discovery proportions for functional magnetic resonance imaging cluster analysis. Statistics in Medicine, 42(14), 2311-2340.
}
\author{
Angela Andreella
}
