% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{overlayToken}
\alias{overlayToken}
\title{Create an overlay token input control}
\usage{
overlayToken(id, name, label = name)
}
\arguments{
\item{id}{A unique ID for the token (a character string without spaces).}

\item{name}{Text (or HTML) to be displayed on the token itself.}

\item{label}{Text label that will appear on the overlay.}
}
\value{
An overlay token input control that can be added to a UI definition.
}
\description{
Create a token that can be dragged onto an \link[=overlayPlotOutput]{overlay plot}
to create a new overlay.
}
\details{
Note that the DOM ID of the token will be converted to
\code{"overshiny_token_<id>"}. This transformed ID is important for internal
interaction logic (e.g. for use with JavaScript drag/drop handlers). When
referencing the token programmatically (e.g. in CSS selectors or custom
JavaScript), use the full prefixed ID (see examples).
}
\examples{
ui <- shiny::fluidPage(
    useOverlay(),
    overlayToken("add", "Add new overlay", "Overlay"),
    # The token's HTML id will be "overshiny_token_add"
    shiny::tags$style(shiny::HTML("#overshiny_token_add { cursor: grab; }"))
)

}
\seealso{
\code{\link[=overlayServer]{overlayServer()}}, for a complete example.
}
