% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounds.R
\name{overlayBounds}
\alias{overlayBounds}
\title{Align overlays with a ggplot2 or base plot}
\usage{
overlayBounds(ov, plot, xlim = c(NA, NA), ylim = c(NA, NA), row = 1L, col = 1L)
}
\arguments{
\item{ov}{A \code{\link[shiny:reactiveValues]{shiny::reactiveValues()}} object returned by \code{\link[=overlayServer]{overlayServer()}}.}

\item{plot}{A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object used for overlay alignment, or the
character string \code{"base"} if you are using base R plotting.}

\item{xlim, ylim}{Vectors defining the coordinate limits for overlays.
Use \code{NA} to inherit axis limits from the plot panel.}

\item{row, col}{Row and column of the facet panel (if applicable). This only
works with ggplot2 plots; base R plots with multiple panels are not
supported.}
}
\value{
The ggplot object (for ggplot2) or \code{NULL} (for base R plotting), to
be returned from the \code{\link[shiny:renderPlot]{shiny::renderPlot()}} block.
}
\description{
Sets the pixel and coordinate bounds of the overlay area based on a
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object or base R plot. This ensures that overlays are
positioned correctly in both visual and coordinate space.
}
\details{
Call this function within \code{\link[shiny:renderPlot]{shiny::renderPlot()}}, before returning the
ggplot object (if using ggplot2) or \code{NULL} (if using base R plotting).
}
\examples{
server <- function(input, output) {
    ov <- overlayServer("my_plot", 1, 1)
    output$my_plot <- shiny::renderPlot({
        plot(1:100, sin(1:100 * 0.1), type = "l")
        overlayBounds(ov, "base", xlim = c(1, 100))
    })
    # further server code here . . .
}

}
\seealso{
\code{\link[=overlayServer]{overlayServer()}}, for a complete example.
}
