test_that("tracer_provider_noop", {
  tp <- tracer_provider_noop$new()
  expect_s3_class(tp, "otel_tracer_provider")
  expect_s3_class(tp, "otel_tracer_provider_noop")
  trc <- tp$get_tracer("test")
  expect_s3_class(trc, "otel_tracer")
  expect_s3_class(trc, "otel_tracer_noop")
  expect_equal(tp$flush(), tp)
  expect_equal(tp$get_spans(), list())
})

test_that("tracer_noop", {
  tp <- tracer_provider_noop$new()
  trc <- tp$get_tracer("test")
  spn <- trc$start_span()
  expect_s3_class(spn, "otel_span")
  expect_s3_class(spn, "otel_span_noop")
  expect_s3_class(trc$get_active_span_context(), "otel_span_context_noop")
  expect_s3_class(trc$get_active_span(), "otel_span_noop")
  expect_false(trc$is_enabled())
  expect_equal(trc$flush(), trc)
  expect_s3_class(trc$extract_http_context(), "otel_span_context_noop")
})

test_that("span_noop", {
  tp <- tracer_provider_noop$new()
  trc <- tp$get_tracer("test")
  spn <- trc$start_span()
  expect_s3_class(spn$get_context(), "otel_span_context_noop")
  expect_false(spn$is_valid())
  expect_false(spn$is_recording())
  expect_equal(spn$set_attribute("key", "value"), spn)
  expect_equal(spn$add_event("name"), spn)
  expect_equal(spn$add_link(spn), spn)
  expect_equal(spn$set_status("ok"), spn)
  expect_equal(spn$update_name("new"), spn)
  expect_equal(spn$record_exception(), spn)
  expect_equal(spn$activate(), spn)
  expect_equal(spn$deactivate(), spn)
  expect_equal(spn$end(), spn)
})

test_that("span_context_noop", {
  tp <- tracer_provider_noop$new()
  trc <- tp$get_tracer("test")
  spn <- trc$start_span()
  spc <- spn$get_context()
  expect_false(spc$is_valid())
  expect_equal(spc$get_trace_flags(), list())
  expect_equal(spc$get_trace_id(), invalid_trace_id)
  expect_equal(spc$get_span_id(), invalid_span_id)
  expect_false(spc$is_remote())
  expect_false(spc$is_sampled())
  expect_snapshot({
    spc$to_http_headers()
  })
})
