% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\docType{data}
\name{tracing-constants}
\alias{tracing-constants}
\alias{invalid_trace_id}
\alias{invalid_span_id}
\alias{span_kinds}
\alias{span_status_codes}
\title{OpenTelemetry tracing constants}
\usage{
invalid_trace_id

invalid_span_id

span_kinds

span_status_codes
}
\value{
Not applicable.
}
\description{
Various constants related OpenTelemetry tracing.
}
\details{
\subsection{\code{invalid_trace_id}}{

\code{invalid_trace_id} is a string scalar, an invalid trace id. If there is
no active span, then \code{\link[=get_active_span_context]{get_active_span_context()}} returns a span context
that has an invalid trace id.
}

\subsection{\code{invalid_span_id}}{

\code{invalid_span_id} is a string scalar, an invalid span id. If there is
no active span, then \code{\link[=get_active_span_context]{get_active_span_context()}} returns a span context
that has an invalid span id.
}

\subsection{\code{span_kinds}}{

\code{span_kinds} is a character vector listing all possible span kinds.
See the \href{https://opentelemetry.io/docs/specs/otel/trace/api/#spankind}{OpenTelemetry specification} for
when to use which.
}

\subsection{\code{span_status_codes}}{

\code{span_status_codes} is a character vector listing all possible span
status codes. You can set the status code of a a span with the
\code{set_status()} method of \link{otel_span} objects. If not set explicitly,
and the span is ended automatically (by \code{\link[=start_local_active_span]{start_local_active_span()}},
\code{\link[=local_active_span]{local_active_span()}} or \code{\link[=with_active_span]{with_active_span()}}), then otel sets the
status automatically to "ok" or "error", depending on whether the span
ended during handling an error.
}
}
\examples{
invalid_trace_id
invalid_span_id
span_kinds
span_status_codes
}
\seealso{
Other OpenTelemetry trace API: 
\code{\link{Zero Code Instrumentation}},
\code{\link{end_span}()},
\code{\link{is_tracing_enabled}()},
\code{\link{local_active_span}()},
\code{\link{start_local_active_span}()},
\code{\link{start_span}()},
\code{\link{with_active_span}()}
}
\concept{OpenTelemetry trace API}
\keyword{datasets}
