% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger-provider-noop.R
\name{otel_logger_provider}
\alias{otel_logger_provider}
\title{OpenTelemetry Logger Provider Object}
\value{
Not applicable.
}
\description{
\link{otel_logger_provider} -> \link{otel_logger}
}
\details{
The logger provider defines how logs are exported when collecting
telemetry data. It is unlikely that you need to use logger provider
objects directly.

Usually there is a single logger provider for an R app or script.

Typically the logger provider is created automatically, at the first
\code{\link[=log]{log()}} call. otel decides which logger provider class to use based on
\link{Environment Variables}.
}
\section{Implementations}{
Note that this list is updated manually and may be incomplete.
\itemize{
\item \link{logger_provider_noop}: No-op logger provider, used when no logs are
emitted.
\item \link[otelsdk:logger_provider_file]{otelsdk::logger_provider_file}: Save logs to a JSONL file.
\item \link[otelsdk:logger_provider_http]{otelsdk::logger_provider_http}: Send logs to a collector over
HTTP/OTLP.
\item \link[otelsdk:logger_provider_stdstream]{otelsdk::logger_provider_stdstream}: Write logs to standard output
or error or to a file. Primarily for debugging.
}
}

\section{Methods}{
\subsection{\code{logger_provider$get_logger()}}{

Get or create a new logger object.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logger_provider$get_logger(
 name = NULL,
 version = NULL,
 schema_url = NULL,
 attributes = NULL
)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name} Logger name. It makes sense to reuse the tracer name as the
logger name. See \code{\link[=get_logger]{get_logger()}} and \code{\link[=default_tracer_name]{default_tracer_name()}}.
\item \code{version}: Optional. Specifies the version of the instrumentation
scope if the scope has a version (e.g. R package version).
Example value: \code{"1.0.0"}.
\item \code{schema_url}: Optional. Specifies the Schema URL that should be
recorded in the emitted telemetry.
\item \code{attributes}: Optional. Specifies the instrumentation scope
attributes to associate with emitted telemetry. See \code{\link[=as_attributes]{as_attributes()}}
for allowed values. You can also use \code{\link[=as_attributes]{as_attributes()}} to convert R
objects to OpenTelemetry attributes.
}
}

\subsection{Value}{

An OpenTelemetry logger (\link{otel_logger}) object.
}

\subsection{See also}{

\code{\link[=get_default_logger_provider]{get_default_logger_provider()}}, \code{\link[=get_logger]{get_logger()}}.
}

}

\subsection{\code{logger_provider$flush()}}{

Force any buffered logs to flush. Logger providers might not implement
this method.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logger_provider$flush()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Nothing.
}

}
}

\examples{
lp <- otel::get_default_logger_provider()
lgr <- lp$get_logger()
lgr$is_enabled()
}
\seealso{
Other low level logs API: 
\code{\link{get_default_logger_provider}()},
\code{\link{get_logger}()},
\code{\link{logger_provider_noop}},
\code{\link{otel_logger}}
}
\concept{low level logs API}
