% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meter-provider-noop.R
\name{otel_histogram}
\alias{otel_histogram}
\title{OpenTelemetry Histogram Object}
\value{
Not applicable.
}
\description{
\link{otel_meter_provider} -> \link{otel_meter} -> \link{otel_counter},
\link{otel_up_down_counter}, \link{otel_histogram}, \link{otel_gauge}
}
\details{
Usually you do not need to deal with otel_histogram objects directly.
\code{\link[=histogram_record]{histogram_record()}} automatically sets up a meter and creates a
histogram instrument, as needed.

A histogram object is created by calling the \code{create_histogram()} method
of an \code{\link[=otel_meter_provider]{otel_meter_provider()}}.

You can use the \code{record()} method to update the statistics with the
specified amount.

In R histogram values are represented by doubles.
}
\section{Methods}{
\subsection{\code{histogram$record()}}{

Update the statistics with the specified amount.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{histogram$record(value, attributes = NULL, span_context = NULL, ...)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{value}: A numeric value to record.
\item \code{attributes}: Additional attributes to add.
\item \code{span_context}: Span context. If missing, the active context is used,
if any.
}
}

\subsection{Value}{

The histogram object itself, invisibly.
}

}
}

\examples{
mp <- get_default_meter_provider()
mtr <- mp$get_meter()
hst <- mtr$create_histogram("response-time")
hst$record(1.123)
}
\seealso{
Other low level metrics API: 
\code{\link{get_default_meter_provider}()},
\code{\link{get_meter}()},
\code{\link{meter_provider_noop}},
\code{\link{otel_counter}},
\code{\link{otel_gauge}},
\code{\link{otel_meter}},
\code{\link{otel_meter_provider}},
\code{\link{otel_up_down_counter}}
}
\concept{low level metrics API}
